﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using AsystentZakupowWPF.Model;

namespace TestyJednostkoweModelu
{
    [TestClass]
    public class UnitTest1
    {
        [TestInitialize]
        public void NaPoczątek()
        {
            //tu można stworzyć plik do testów
        }

        private Sumator stwórzSumator(decimal suma)
        {
            return new Sumator(1000, suma);
        }

        [TestMethod]
        public void TestKonstruktoraIWłasnościSuma()
        {
            //przygotowania (arrange)
            decimal suma = 550;

            //testowane działanie (act)
            Sumator model = stwórzSumator(550);        
            decimal model_Suma = model.Suma;

            //weryfikacja (assert)
            Assert.AreEqual(suma, model_Suma);
        }

        [TestMethod]
        public void TestMetodyDodaj()
        {
            decimal suma = 500;
            decimal kwota = 250;

            Sumator model = stwórzSumator(suma);
            bool wynik = model.Dodaj(kwota);

            Assert.IsTrue(wynik);
            Assert.AreEqual(suma + kwota, model.Suma);
        }

        [TestMethod]
        public void TestMetodyDodajZaDużo()
        {
            decimal suma = 900;
            decimal kwota = 250;

            Sumator model = stwórzSumator(suma);
            bool wynik = model.Dodaj(kwota);

            Assert.IsFalse(wynik);
            Assert.AreEqual(suma, model.Suma);
        }

        [TestMethod]
        public void TestujSprawdźKwotę()
        {
            Sumator model = stwórzSumator(500);

            Assert.IsTrue(model.SprawdźKwotę(100), "arg: 100");
            Assert.IsTrue(model.SprawdźKwotę(200), "arg: 200");
            Assert.IsTrue(model.SprawdźKwotę(500), "arg: 500");
            Assert.IsFalse(model.SprawdźKwotę(600), "arg: 600");
        }

        [TestMethod]
        public void TestujSprawdźSumęWyjątekNie()
        {
            Sumator model = stwórzSumator(500);

            model.SprawdźKwotęPrzykładDoTestów(100);
            model.SprawdźKwotęPrzykładDoTestów(200);
            model.SprawdźKwotęPrzykładDoTestów(500);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestujSprawdźSumęWyjątekTak()
        {
            Sumator model = stwórzSumator(500);

            model.SprawdźKwotęPrzykładDoTestów(600);
        }

        [TestMethod]
        public void TestSamegoKonstruktora() //test czarnej skrzynki
        {
            decimal suma = 550M;
            Sumator model = stwórzSumator(suma);

            PrivateObject po = new PrivateObject(model);
            decimal model_suma = (decimal)po.GetField("suma");

            Assert.AreEqual(suma, model_suma);
        }
    }
}
