﻿using System;
using System.Globalization;
using System.Windows.Data;
using System.Windows.Media;

namespace PierwszaAplikacjaWPF.ModelWidoku
{
    public class WartośćJakoTekstConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double wartość = (double)value;
            return wartość.ToString();
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string tekst = (string)value;
            return double.Parse(tekst);
        }
    }

    public class KonwerterWartościDoKoloru : IValueConverter
    {
        public bool ZmienionaPaletaKolorów { get; set; } = false;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            Brush b1 = Brushes.Lime;
            Brush b2 = Brushes.Yellow;
            Brush b3 = Brushes.Red;
            if(ZmienionaPaletaKolorów)
            {
                b1 = Brushes.Cyan;
                b2 = Brushes.Blue;
                b3 = Brushes.Navy;
            }
            double wartość = (double)value;
            if (wartość < 33) return b1;
            if (wartość < 66) return b2;
            return b3;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
