﻿using System;

namespace KalkulatorVAT.Model
{
    class Kalkulator
    {
        private decimal vat1, vat2;

        public bool ChangeVats(decimal vat1, decimal vat2)
        {
            if (checkVats(vat1, vat2) == false) return false;

            this.vat1 = vat1;
            this.vat2 = vat2;
            return true;
        }

        public Kalkulator(decimal vat1,decimal vat2)
        {
            if (!ChangeVats(vat1, vat2))
                throw new Exception("Niepoprawne stawki VAT");
        }

        /*
        private bool check(decimal vat1, decimal vat2)
        {
            if (vat1 < 0 || vat1 > 100) return false;
            if (vat2 < 0 || vat2 > 100) return false;
            if (vat1 > vat2) return false;
            return true;
        }
        */

        private static bool checkVat(decimal vat)
        {
            return vat >= 0 && vat <= 100;
        }

        private bool checkVats(decimal vat1, decimal vat2)
        {
            //Func<decimal,bool> checkVat = (decimal vat) => { return vat >= 0 && vat <= 100; }; //wyrażenie Lambda
            return checkVat(vat1) && checkVat(vat2) && vat1 < vat2;
        }

        private decimal obliczKwotęZVat(decimal kwota,decimal vat)
        {
            return kwota + (vat / 100) * kwota;
        }
        public void ObliczVat(decimal kwota, out decimal kwotaVat1, out decimal kwotaVat2)
        {
            kwotaVat1 = obliczKwotęZVat(kwota, vat1);
            kwotaVat2 = obliczKwotęZVat(kwota, vat2);
        }
    }
}
