﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace Zadania.ViewModel
{
    using PSPiZK;

    public class Zadanie : INotifyPropertyChanged
    {
        private Model.Zadanie model;

        public string Opis
        {
            get
            {
                return model.Opis;
            }
        }

        public Model.PriorytetZadania Priorytet
        {
            get
            {
                return model.Priorytet;
            }
        }

        public DateTime DataUtworzenia
        {
            get
            {
                return model.DataUtworzenia;
            }
        }

        public DateTime PlanowanaDataRealizacji
        {
            get
            {
                return model.PlanowanaDataRealizacji;
            }
        }

        public bool CzyZrealizowane
        {
            get
            {
                return model.CzyZrealizowane;
            }
        }

        public bool CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminie
        {
            get
            {
                return !CzyZrealizowane && (DateTime.Now > PlanowanaDataRealizacji);
            }
        }

        public Zadanie(Model.Zadanie zadanie)
        {
            this.model = zadanie;
        }

        public Zadanie(
            string opis, 
            DateTime dataUtworzenia, 
            DateTime planowanaDataRealizacji,
            Model.PriorytetZadania priorytet,
            bool czyZrealizowane)
            //: this(new Model.Zadanie(opis, dataUtworzenia, planowanaDataRealizacji, priorytet, czyZrealizowane))
        {
            this.model = new Model.Zadanie(opis, dataUtworzenia, planowanaDataRealizacji, priorytet, czyZrealizowane);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged!=null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        private ICommand oznaczJakoZrealizowane = null;

        public ICommand OznaczJakoZrealizowane
        {
            get
            {
                if (oznaczJakoZrealizowane == null)
                    oznaczJakoZrealizowane = new MvvmCommand(
                        o =>
                        {
                            model.CzyZrealizowane = true;
                            OnPropertyChanged(
                                nameof(CzyZrealizowane),
                                nameof(CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminie));
                        },
                        o =>
                        {
                            return !model.CzyZrealizowane;
                        }
                        );
                return oznaczJakoZrealizowane;
            }
        }

        private ICommand oznaczJakoNiezrealizowane = null;

        public ICommand OznaczJakoNiezrealizowane
        {
            get
            {
                if (oznaczJakoNiezrealizowane == null)
                    oznaczJakoNiezrealizowane = new MvvmCommand(
                        o =>
                        {
                            model.CzyZrealizowane = false;
                            OnPropertyChanged(
                                nameof(CzyZrealizowane),
                                nameof(CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminie));
                        },
                        o =>
                        {
                            return model.CzyZrealizowane;
                        }
                        );
                return oznaczJakoNiezrealizowane;
            }
        }

        public Model.Zadanie PobierzModel()
        {
            return model;
        }
    }
}
