﻿using System;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Windows.Input;

namespace Zadania.ViewModel
{
    using PSPiZK;

    public class Zadania
    {
        private string ścieżkaPlikuXML = "zadania.xml";

        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        public Zadania()
        {
            if (System.IO.File.Exists(ścieżkaPlikuXML))
                model = Model.PlikXML.Czytaj(ścieżkaPlikuXML);
            else model = new Model.Zadania();

            /*
            //testy
            model.DodajZadanie(
                new Model.Zadanie(
                    "Pierwszy",
                    DateTime.Now, DateTime.Now.AddDays(1),
                    Model.PriorytetZadania.Ważne, false));
            model.DodajZadanie(
                new Model.Zadanie(
                    "Drugie",
                    DateTime.Now, DateTime.Now.AddDays(3),
                    Model.PriorytetZadania.Krytyczne, false));
            model.DodajZadanie(
                new Model.Zadanie(
                    "Trzecie",
                    DateTime.Now, DateTime.Now.AddDays(3),
                    Model.PriorytetZadania.MniejWażne, false));
            Model.PlikXML.Zapisz(ścieżkaPlikuXML, model);
            */

            kopiujZadaniaZModelu();

            /*
            //test
            ListaZadań.Add(new Zadanie("Czwarte", DateTime.Now, DateTime.Now.AddYears(1), Model.PriorytetZadania.Ważne, false));
            */
        }

        private void kopiujZadaniaZModelu() //synchronizacja M->VM
        {
            ListaZadań.CollectionChanged -= synchronizacjaModelu;
            ListaZadań.Clear();
            foreach(Model.Zadanie zadanie in model)
            {
                ListaZadań.Add(new Zadanie(zadanie));
            }
            ListaZadań.CollectionChanged += synchronizacjaModelu;
        }

        private void synchronizacjaModelu(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch(e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = (Zadanie)e.NewItems[0]; //dodaje tylko jeden
                    if (noweZadanie != null) model.DodajZadanie(noweZadanie.PobierzModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = (Zadanie)e.OldItems[0];
                    if (usuwaneZadanie != null) model.UsuńZadanie(usuwaneZadanie.PobierzModel());
                    break;
            }
        }

        private ICommand zapiszCommand;

        public ICommand ZapiszCommand
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new MvvmCommand(
                        argument =>
                        {
                            System.IO.File.Copy(ścieżkaPlikuXML, ścieżkaPlikuXML + ".bak", true);
                            Model.PlikXML.Zapisz(ścieżkaPlikuXML, model);
                        });
                return zapiszCommand;
            }
        }
    }
}
