﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;

//DAL
namespace Zadania.Model
{
    public static class PlikXML
    {
        private static readonly IFormatProvider formatProvider = System.Globalization.CultureInfo.InvariantCulture;
        //private static readonly IFormatProvider formatProvider = new System.Globalization.CultureInfo("pl-PL");

        const string nazwaElementuOpis = "Opis";

        public static void Zapisz(string ścieżkaPliku, Zadania zadania)
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Data zapisania: " + DateTime.Now.ToString()),
                    new XElement("Zadania",
                        from Zadanie zadanie in zadania
                        select new XElement("Zadanie",
                            new XElement(nazwaElementuOpis, zadanie.Opis),
                            new XElement("DataUtworzenia", zadanie.DataUtworzenia.ToString(formatProvider)),
                            new XElement("PlanowanaDataRealizacji", zadanie.PlanowanaDataRealizacji.ToString(formatProvider)),
                            new XElement("Priorytet", zadanie.Priorytet),
                            new XElement("CzyZrealizowane", zadanie.CzyZrealizowane.ToString(formatProvider))
                        )
                    )
                );
                xml.Save(ścieżkaPliku);
            }
            catch (Exception exc)
            {
                throw new Exception("Błąd przy zapisie danych do pliku XML", exc);
            }
        }

        public static Zadania Czytaj(string ścieżkaPliku)
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                IEnumerable<Zadanie> dane =
                    from zadanie in xml.Root.Descendants("Zadanie")
                    select new Zadanie(
                        zadanie.Element(nazwaElementuOpis).Value,
                        DateTime.Parse(zadanie.Element("DataUtworzenia").Value, formatProvider),
                        DateTime.Parse(zadanie.Element("PlanowanaDataRealizacji").Value, formatProvider),
                        (Model.PriorytetZadania)Enum.Parse(typeof(Model.PriorytetZadania), zadanie.Element("Priorytet").Value),
                        bool.Parse(zadanie.Element("CzyZrealizowane").Value));

                Zadania model = new Zadania();
                foreach (Zadanie zadanie in dane) model.DodajZadanie(zadanie);
                return model;
            }
            catch (Exception exc)
            {
                throw new Exception("Błąd przy odczycie danych z pliku XML", exc);
            }
        }
    }
}
