﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;

namespace Zadania
{
    public class BoolToBrushConverter : IValueConverter
    {
        public Brush KolorDlaPrawdy { get; set; } = Brushes.Black;
        public Brush KolorDlaFałszu { get; set; } = Brushes.Gray;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            bool bvalue = (bool)value;
            return bvalue ? KolorDlaPrawdy : KolorDlaFałszu;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class PriorytetZadaniaToString : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            Model.PriorytetZadania priorytet = (Model.PriorytetZadania)value;
            switch (priorytet)
            {
                case Model.PriorytetZadania.MniejWażne:
                    return "mniej ważne";
                case Model.PriorytetZadania.Ważne:
                    return "ważne";
                case Model.PriorytetZadania.Krytyczne:
                    return "krytyczne";
                default:
                    throw new Exception("Nierozpoznany priorytet");
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class PriorytetZadaniaToBrush : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            Model.PriorytetZadania priorytet = (Model.PriorytetZadania)value;
            switch (priorytet)
            {
                case Model.PriorytetZadania.MniejWażne:
                    return Brushes.Olive;
                case Model.PriorytetZadania.Ważne:
                    return Brushes.Orange;
                case Model.PriorytetZadania.Krytyczne:
                    return Brushes.OrangeRed;
                default:
                    throw new Exception("Nierozpoznany priorytet");
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
