﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadania.Model
{
    public enum PriorytetZadania : byte { MniejWażne, Ważne, Krytyczne };

    public class Zadanie
    {
        public string Opis { get; private set; }
        public DateTime DataUtworzenia { get; private set; }
        public DateTime PlanowanaDataRealizacji { get; private set; }
        public PriorytetZadania Priorytet { get; private set; }
        public bool CzyZrealizowane { get; set; } //tylko to może być zmieniane

        public Zadanie(
            string opis, 
            DateTime dataUtworzenia, 
            DateTime dataRealizacji, 
            PriorytetZadania priorytet, 
            bool czyZrealizowane)
        {
            this.Opis = opis;
            this.DataUtworzenia = dataUtworzenia;
            this.PlanowanaDataRealizacji = dataRealizacji;
            this.Priorytet = priorytet;
            this.CzyZrealizowane = czyZrealizowane;
        }

        public override string ToString()
        {
            return Opis;
        }
    }
}
