﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;

//DAL
namespace Zadania.Model
{
    public static class PlikXML
    {
        public static void Zapisz(string ścieżkaPliku, Zadania zadania)
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Data zapisania: " + DateTime.Now.ToString()),
                    new XElement("Zadania",
                        from Zadanie zadanie in zadania
                        select new XElement("Zadanie",
                            new XElement("Opis", zadanie.Opis),
                            new XElement("DataUtworzenia", zadanie.DataUtworzenia),
                            new XElement("PlanowanaDataRealizacji", zadanie.PlanowanaDataRealizacji),
                            new XElement("Priorytet", zadanie.Priorytet),
                            new XElement("CzyZrealizowane", zadanie.CzyZrealizowane)
                        )
                    )
                );
                xml.Save(ścieżkaPliku);
            }
            catch(Exception exc)
            {
                throw new Exception("Błąd przy zapisie danych do pliku XML", exc);
            }
        }
    }
}
