﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Media;
using System.ComponentModel;
using System.Windows.Input;

namespace Kolory_WPF.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = new Model.Kolor() { R = 0, G = 0, B = 0 };

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(
                    this,
                    new PropertyChangedEventArgs(nazwaWłasności));
        }

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R));
                onPropertyChanged(nameof(Kolor));
                //onPropertyChanged(nameof(Pędzel));
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G));
                onPropertyChanged(nameof(Kolor));
                //onPropertyChanged(nameof(Pędzel));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B));
                onPropertyChanged(nameof(Kolor));
                //onPropertyChanged(nameof(Pędzel));
            }
        }

        public Color Kolor
        {
            get
            {
                return Color.FromRgb(model.R, model.G, model.B);
            }
        }

        /*
        public Brush Pędzel
        {
            get
            {
                return new SolidColorBrush(Kolor);
            }
        }
        */

        private ICommand resetuj = null;

        public ICommand Resetuj
        {
            get
            {
                if(resetuj == null)
                {
                    resetuj = new PSPiZK.MvvmCommand(
                        (object o) =>
                        {
                            R = 0;
                            G = 0;
                            B = 0;
                        },
                        (object o) =>
                        {
                            return R != 0 || G != 0 || B != 0;
                        });               
                }
                return resetuj;
            }
        }
    }
}
