﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;
using BibliotekaKontrolka.Model;

namespace BibliotekaKontrolka.ModelWidoku
{
    public class SciezkaVM : INotifyPropertyChanged

    {
        public Plik model = new Plik();
        public string SciezkaPliku
        {
            get
            {
                return model.sciezkaPliku;
            }
            set
            {
                model.sciezkaPliku = value;
                OnPropertyChanged(nameof(SciezkaPliku));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        public ICommand wypisz;
        public ICommand Wypisz
         {
            get
            {
                if (wypisz == null)
                    wypisz = new RelayCommand(
                        o =>
                        {
                            string ściezka = (string)o;
                            if (ściezka != null) SciezkaPliku = ściezka;
                        });
            return wypisz;
            }
        }


    }
}

        