﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace Notatnik
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                Text = "Notatnik - " + Path.GetFileName(openFileDialog1.FileName);
                textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                File.WriteAllLines(saveFileDialog1.FileName, textBox1.Lines);
                Text = "Notatnik - " + Path.GetFileName(saveFileDialog1.FileName);
            }
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if(colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void pasekStanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinadataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToString();
        }

        private StringReader sr = null;

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            float wysokośćWiersza = czcionka.GetHeight(e.Graphics);
            int liczbaLinii = (int)Math.Floor(e.MarginBounds.Height / wysokośćWiersza);

            if (sr == null)
            {
                string tekst = "";
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokość = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokość < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float średniaSzerokośćLitery = szerokość / wiersz.Length;
                        int ileLiterWWierszu = (int)(e.MarginBounds.Width / średniaSzerokośćLitery);
                        int ileRazy = wiersz.Length / ileLiterWWierszu; // ile wierszy
                        for (int i = 0; i < ileRazy; i++)
                        {
                            tekst += wiersz.Substring(i * ileLiterWWierszu, ileLiterWWierszu) + "\n";
                        }
                        tekst += wiersz.Substring(ileRazy * ileLiterWWierszu) + "\n";
                    }
                }
                sr = new StringReader(tekst);
            }
             
            e.HasMorePages = true;

            for(int i = 0; i <liczbaLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                else
                {
                    e.Graphics.DrawString(wiersz,
                        czcionka,
                        Brushes.Black,
                        e.MarginBounds.Left,
                        e.MarginBounds.Top + i * wysokośćWiersza);
                }
            }
        }

        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            DialogResult dr = printDialog1.ShowDialog();
            if(dr == DialogResult.OK)
            {
                printDocument1.DocumentName = "Notatnik.NET ";
                if (!string.IsNullOrEmpty(openFileDialog1.FileName))
                    printDocument1.DocumentName += openFileDialog1.FileName;
                //printDocument1.Print();
                backgroundWorker1.RunWorkerAsync();
            }
        }

        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }

        private void toolStripMenuItem6_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            printDocument1.Print();
        }
    }
}
