﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DragAndDrop
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            for(int i = 0; i< 10; ++i)
            {
                listBox1.Items.Add("Lista 1, element " + i.ToString());
                listBox2.Items.Add("Lista 2, element " + i.ToString());
            }
        }

        ListBox lbŹródło = null;

        private void listBox1_MouseDown(object sender, MouseEventArgs e)
        {
            ListBox listBox = sender as ListBox;
            lbŹródło = listBox;
            listBox.DoDragDrop(
                listBox.SelectedItem, 
                DragDropEffects.Move | DragDropEffects.Copy);            
        }

        private void listBox2_DragOver(object sender, DragEventArgs e)
        {
            //Text = e.KeyState.ToString();
            if (sender == lbŹródło)
            {
                e.Effect = DragDropEffects.None;
            }
            else
            {
                if (e.KeyState == 9) e.Effect = DragDropEffects.Copy;
                else e.Effect = DragDropEffects.Move;
            }
        }

        private void listBox2_DragDrop(object sender, DragEventArgs e)
        {
            ListBox listBox = sender as ListBox;
            listBox.Items.Add(lbŹródło.SelectedItem);
            if (e.Effect == DragDropEffects.Move) lbŹródło.Items.Remove(lbŹródło.SelectedItem);
        }
    }
}
