﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace generowanieKolorow
{
    class HSLColorPallete
    {
        public Bitmap b { get; }
        public bool mouseDownOverPalete { get; set; }

        public HSLColorPallete(int R, double light)
        {
            mouseDownOverPalete = false;

            b = new Bitmap(2 * R+1, 2 * R+1);
            Point O = new Point(R, R);

            for (int x = 0; x <= 2 * R; x++)
            {
                for (int y = 0; y <= 2 * R; y++)
                {
                    int r = (int)pointDist(O, new Point(x, y));

                    if (r < R)
                    {
                        if (y < R)
                        {
                            b.SetPixel(
                                x,
                                y,
                                ColorFromHSV((double)Vector.AngleBetween(new Vector(1, 0), new Vector(R, R, x, y)), (double)r / R, light)
                                );
                        }
                        else
                        {
                            b.SetPixel(
                                x,
                                y,
                                ColorFromHSV((double)Vector.AngleBetween(new Vector(-1, 0), new Vector(R, R, x, y)) + 180, (double)r / R, light)
                                );
                        }
                    }
                    else if (r == R)
                        b.SetPixel(x, y, Color.Black);


                }
            }
        }

        public bool isPointInsidePallete(Point p)
        {
            Point cenrer = new Point((b.Width - 1) / 2, (b.Width - 1) / 2);
            if (pointDist(p,cenrer) < ((b.Width - 1) / 2)) return true;
            return false;
        }

        public static Color ColorFromHSV(double hue, double saturation, double value)
        {
            int hi = Convert.ToInt32(Math.Floor(hue / 60)) % 6;
            double f = hue / 60 - Math.Floor(hue / 60);

            value = value * 255;
            int v = Convert.ToInt32(value);
            int p = Convert.ToInt32(value * (1 - saturation));
            int q = Convert.ToInt32(value * (1 - f * saturation));
            int t = Convert.ToInt32(value * (1 - (1 - f) * saturation));

            if (hi == 0)
                return Color.FromArgb(255, v, t, p);
            else if (hi == 1)
                return Color.FromArgb(255, q, v, p);
            else if (hi == 2)
                return Color.FromArgb(255, p, v, t);
            else if (hi == 3)
                return Color.FromArgb(255, p, q, v);
            else if (hi == 4)
                return Color.FromArgb(255, t, p, v);
            else
                return Color.FromArgb(255, v, p, q);
        }

        public static double pointDist(Point a, Point b)
        {
            return Math.Sqrt((double)Math.Pow(a.X - b.X, 2) + (double)Math.Pow(a.Y - b.Y, 2));
        }

    }
}

