﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Kolekcje.Model
{
    public static class PlikXML
    {
        public static void Zapisz(string ścieżkaPliku, Zadania zadania)
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Data zapisania: " + DateTime.Now.ToString()),
                    new XElement("Zadania",
                        from Zadanie zadanie in zadania
                        select new XElement("Zadanie",
                            new XElement("Opis", zadanie.Opis.ToString()),
                            new XElement("DataUtworzenia", zadanie.DataUtworzenia.ToString()),
                            new XElement("PlanowanyTerminRealizacji", zadanie.PlanowanyTerminRealizacji.ToString()),
                            new XElement("Priorytet", zadanie.Priorytet.ToString()),
                            new XElement("CzyZrealizowane", zadanie.CzyZrealizowane.ToString()))));
                xml.Save(ścieżkaPliku);
            }
            catch(Exception exc)
            {
                throw new Exception("Błąd przy zapisie do pliku XML: " + exc.Message, exc);
            }
        }

        public static Zadania Czytaj(string ścieżkaPliku)
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                IEnumerable<Zadanie> dane =
                    from XElement zadanie in xml.Root.Descendants("Zadanie")
                    select new Zadanie(
                        zadanie.Element("Opis").Value,
                        DateTime.Parse(zadanie.Element("DataUtworzenia").Value),
                        DateTime.Parse(zadanie.Element("PlanowanyTerminRealizacji").Value),
                        PriorytetZadania.MniejWażne,
                        bool.Parse(zadanie.Element("CzyZrealizowane").Value));
                Zadania zadania = new Zadania();
                foreach (Zadanie zadanie in dane) zadania.DodajZadanie(zadanie);
                return zadania;
            }
            catch(Exception exc)
            {
                throw new Exception("Błąd przy odczycie z pliku XML: " + exc.Message, exc);
            }
        }
    }
}
