﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Kolekcje.ModelWidoku
{
    public class Zadania
    {
        private const string ścieżkaPlikuXml = "zadania.xml";

        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; }

        private void kopiujZadaniaZModelu() //z modelu do kolekcji obserwowalnej
        {
            ListaZadań.CollectionChanged -= SynchronizacjaZadań;
            ListaZadań.Clear();
            foreach (Model.Zadanie zadanie in model)
                ListaZadań.Add(new Zadanie(zadanie));
            ListaZadań.CollectionChanged += SynchronizacjaZadań;
        }

        public Zadania()
        {
            if (System.IO.File.Exists(ścieżkaPlikuXml))
                model = Model.PlikXML.Czytaj(ścieżkaPlikuXml);
            else model = new Model.Zadania();

            kopiujZadaniaZModelu();
        }

        private void SynchronizacjaZadań(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch(e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    {
                        Zadanie zadanie = (Zadanie)e.NewItems[0];
                        if (zadanie != null) model.DodajZadanie(zadanie.GetModel());
                    }
                    break;
                case NotifyCollectionChangedAction.Remove:
                    {
                        Zadanie zadanie = (Zadanie)e.OldItems[0];
                        if (zadanie != null) model.UsuńZadanie(zadanie.GetModel());
                    }
                    break;
            }
        }
    }
}
