﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AsystentZakupówWPF.Model;
using System.Windows.Input;
using System.ComponentModel;

namespace AsystentZakupówWPF.ModelWidoku
{
    public class ModelWidoku : INotifyPropertyChanged
    {
        //instancja modelu
        private AutoSumowanie model = new AutoSumowanie (0, 1000);
        private ICommand dodaj;

        //własność Suma
        public string Suma
        {
            get 
            { 
                return model.Suma.ToString();
            }             
        }

        public ModelWidoku()
        {
            CzyJestBezpiecznie = true;
        }

        public bool CzyJestBezpiecznie { get; private set; }

        //polecenie Dodaj
        public ICommand Dodaj
        {
            get 
            {
                if(dodaj == null)
                    dodaj = new MvvmCommand(
                        (object o) => 
                        {
                            //string skwota = (string)o;
                            //decimal kwota = decimal.Parse(skwota);
                            decimal kwota = (decimal)o;
                            try
                            {
                                if (kwota < 0) throw new Exception();
                                CzyJestBezpiecznie = true;
                                model.Dodaj(kwota);
                                OnPropertyChanged("Suma");
                            }
                            catch(Exception)
                            {
                                CzyJestBezpiecznie = false;
                            }
                            OnPropertyChanged("CzyJestBezpiecznie");
                            
                        });
                return dodaj; 
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
