﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PasekPostępu.ViewModel
{
    using Model;
    using System.Windows.Input;

    public class ModelWidoku : INotifyPropertyChanged
    {
        public int WartośćMinimalna { get; private set; }
        public int WartośćMaksymalna { get; private set; }

        private Model model = new Model();

        public ModelWidoku()
        {
            WartośćMinimalna = 0;
            WartośćMaksymalna = 100;
        }

        public double Wartość
        {
            get
            {
                return model.Wartość;
            }
            set
            {
                model.Wartość = value;
                OnPropertyChanged("Wartość");
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        private ICommand ustalMinimalnąWartośćCommand;

        public ICommand UstalMinimalnąWartość
        {
            get
            {
                if (ustalMinimalnąWartośćCommand == null)
                    ustalMinimalnąWartośćCommand = new MvvmCommand(
                        (object o) => { Wartość = WartośćMinimalna; },
                        (object o) => { return Wartość != WartośćMinimalna; }
                        );
                return ustalMinimalnąWartośćCommand;
            }
        }

        private ICommand ustalMaksymalnąWartośćCommand;

        public ICommand UstalMaksymalnąWartość
        {
            get
            {
                if (ustalMaksymalnąWartośćCommand == null)
                    ustalMaksymalnąWartośćCommand = new MvvmCommand(
                        (object o) => { Wartość = WartośćMaksymalna; },
                        (object o) => { return Wartość != WartośćMaksymalna; }
                        );
                return ustalMaksymalnąWartośćCommand;
            }
        }
    }
}
