﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AsystentZakupówWPF.Model;
using System.Windows.Input;
using System.ComponentModel;

namespace AsystentZakupówWPF.ModelWidoku
{
    public class ModelWidoku : INotifyPropertyChanged
    {
        //instancja modelu
        private AutoSumowanie model = new AutoSumowanie (0, 1000);
        private ICommand dodaj;

        //własność Suma
        public string Suma
        {
            get 
            { 
                return model.Suma.ToString();
            }             
        }

        //polecenie Dodaj
        public ICommand Dodaj
        {
            get 
            {
                if(dodaj == null)
                    dodaj = new MvvmCommand(
                        (object o) => 
                        {
                            string skwota = (string)o;
                            decimal kwota = decimal.Parse(skwota);
                            model.Dodaj(kwota);
                            if (PropertyChanged != null)
                                PropertyChanged(null, new PropertyChangedEventArgs("Suma"));
                        });
                return dodaj; 
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;
    }
}
