﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LambdaExpressions
{
    class Program
    {
        private static void PokażNaŻółto(string tekst)
        {
            ConsoleColor kolor = Console.ForegroundColor;
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.WriteLine(tekst);
            Console.ForegroundColor = kolor;
        }

        private static void PokażNaZielono(string tekst)
        {
            ConsoleColor kolor = Console.ForegroundColor;
            Console.ForegroundColor = ConsoleColor.Green;
            Console.WriteLine(tekst);
            Console.ForegroundColor = kolor;
        }

        private static int sumuj(params int[] t)
        {
            int suma = 0;
            for (int i = 0; i < t.Length; ++i) suma += t[i];
            return suma;
        }

        static double funkcjaLiniowa(double x)
        {
            return 2 * x;
        }

        private static double pochodnaWPunkcie(Func<double, double> f, double x)
        {
            const double dx = 0.01;
            return (f(x + dx) - f(x - dx)) / (2 * dx);
        }

        static void Main(string[] args)
        {
            /*
            for (int i = 0; i < 100; ++i)
            {
                Action<string> show;
                if (DateTime.Now.Ticks % 2 == 0) show = PokażNaŻółto;
                else show = PokażNaZielono;
                Show("PSPiZK");
            }
            */

            Action<string, ConsoleColor> showColor = (string tekst, ConsoleColor kolor) => 
            {
                ConsoleColor _kolor = Console.ForegroundColor;
                Console.ForegroundColor = kolor;
                Console.WriteLine(tekst);
                Console.ForegroundColor = _kolor;
            };
            showColor("PSPiZK", ConsoleColor.Cyan);

            Func<int, int, int, int> sumuj = (int a, int b, int c) => { return a + b + c; };
            Console.WriteLine(sumuj(1, 2, 3).ToString());

            int[] t = new int[4] { 1, 2, 3, 4 };
            Console.WriteLine(Program.sumuj(t).ToString());
            Console.WriteLine(Program.sumuj(1, 2, 3, 4, 5, 6).ToString());

            //-------------------------

            double wynik = pochodnaWPunkcie(funkcjaLiniowa, 2);
            Console.WriteLine(wynik.ToString());

            wynik = pochodnaWPunkcie((double x) => { return x * x; }, 2);
            Console.WriteLine(wynik.ToString());
        }
    }
}
