﻿using System.ComponentModel;
using System.Windows.Media;

namespace KoloryWPF.ViewModel
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = Model.Ustawienia.Czytaj();

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                OnPropertyChanged("R");
                OnPropertyChanged("Color");
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                OnPropertyChanged("G");
                OnPropertyChanged("Color");
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                OnPropertyChanged("B");
                OnPropertyChanged("Color");
            }
        }

        public Color Color
        {
            get
            {
                return model.ToColor();
            }
        }

        public void Zapisz()
        {
            Model.Ustawienia.Zapisz(model);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }

    static class KolorExtensions
    {
        public static Color ToColor(this Model.Kolor kolor)
        {
            return Color.FromRgb(kolor.R, kolor.G, kolor.B);
        }
    }
}
