﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace KoloryWPF
{
    using ViewModel;

    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            Color kolor = Model.Ustawienia.Czytaj().ToColor();
            //KolorProstokąta = kolor;
            sliderR.Value = kolor.R;
            sliderG.Value = kolor.G;
            sliderB.Value = kolor.B;
            //Slider_ValueChanged(null, null);
        }

        /*
        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            Color kolor = Color.FromRgb(
                (byte)sliderR.Value, 
                (byte)sliderG.Value, 
                (byte)sliderB.Value);
            KolorProstokąta = kolor;            
        }
        */

        private Color KolorProstokąta
        {
            get
            {
                if (rectangle.Fill == null) return Colors.Transparent;
                else return (rectangle.Fill as SolidColorBrush).Color;
            }
            set
            {
                if (rectangle.Fill == null) rectangle.Fill = new SolidColorBrush(value);
                else (rectangle.Fill as SolidColorBrush).Color = value;
            }
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            Model.Ustawienia.Zapisz(
                new Model.Kolor(
                    KolorProstokąta.R, 
                    KolorProstokąta.G, 
                    KolorProstokąta.B));
        }
    }
}
