﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Projekt;

namespace TestyJednostkowe
{
    [TestClass]
    public class UłamekTesty
    {
        [TestMethod]
        public void TestKonstruktoraWłasnościIMetodyUprość()
        {
            //przygotowania (arrange)
            int licznik = 1;
            int mianownik = 2;

            //działanie (act)
            Ułamek u = new Ułamek(licznik, mianownik);
            int wynik_licznik = u.Licznik;
            int wynik_mianownik = u.Mianownik;

            //weryfikacja (assert)
            Assert.AreEqual(licznik, wynik_licznik);
            Assert.AreEqual(mianownik, wynik_mianownik);
        }

        [TestMethod]
        public void TestMetodyUprość()
        {
            //przygotowania (arrange)
            Ułamek u = new Ułamek();
            u.Licznik = 2;
            u.Mianownik = 4;

            //działanie (act)
            u.Uprość();

            //weryfikacja (assert)
            Assert.AreEqual(1, u.Licznik);
            Assert.AreEqual(2, u.Mianownik);
        }

        [TestMethod]
        public void TestMetodyUprośćDużeLiczby()
        {
            //przygotowania (arrange)
            Ułamek u = new Ułamek();
            u.Licznik = int.MaxValue;
            u.Mianownik = int.MaxValue;

            //działanie (act)
            u.Uprość();

            //weryfikacja (assert)
            Assert.AreEqual(1, u.Licznik);
            Assert.AreEqual(2, u.Mianownik);
        }

        [TestMethod]
        public void TestMetodyUprośćPO()
        {
            //przygotowania (arrange)
            Ułamek u = new Ułamek();
            PrivateObject pou = new PrivateObject(u);
            pou.SetField("licznik", 2);
            pou.SetField("mianownik", 4);

            //działanie (act)
            //u.Uprość();
            pou.Invoke("Uprość");

            //weryfikacja (assert)
            int wynik_licznik = (int)pou.GetField("licznik");
            int wynik_mianownik = (int)pou.GetField("mianownik");
            Assert.AreEqual(1, wynik_licznik);
            Assert.AreEqual(2, wynik_mianownik);            
        }

        [TestMethod]
        [ExpectedException(typeof(DivideByZeroException))]
        public void TestKonstruktoraWyjątek()
        {
            new Ułamek(1, 0);
        }

        [TestMethod]
        public void TestSortowania()
        {
            //arrange
            Ułamek[] tu = new Ułamek[3]
                {                    
                    new Ułamek(1,2),
                    new Ułamek(3,1),
                    new Ułamek(1,3)
                };

            //act
            Array.Sort(tu);

            //assert
            for(int i=0;i<tu.Length-1;++i)
            {
                if (tu[i] > tu[i + 1]) Assert.Fail();                
            }
        }
    }
}
