﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Projekt
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                Ułamek u = new Ułamek(1);
                u.Mianownik = 1;

                Ułamek u1 = new Ułamek(2, 1);
                MessageBox.Show(u1.ToString());

                Ułamek u2 = new Ułamek(1, 3);
                MessageBox.Show(u2.ToString());

                Ułamek połowa = Ułamek.Połowa;

                double d1 = (double)u1;
                MessageBox.Show(d1.ToString());

                double d2 = (double)u2;
                MessageBox.Show(d2.ToString());

                Ułamek suma = u1 + u2;
                MessageBox.Show(suma.ToString());
                if (suma.Licznik != 7 || suma.Mianownik != 3) throw new Exception("Test niezaliczony");

                Ułamek u0 = new Ułamek(4, 8);
                MessageBox.Show(u0.ToString());

                Ułamek[] tu = new Ułamek[3]
                {                    
                    new Ułamek(1,2),
                    new Ułamek(3,1),
                    new Ułamek(1,3)
                };
                Array.Sort(tu);

                button3.Click += button3_Click;
            }
            catch(Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        }

        void button3_Click(object sender, EventArgs e)
        {
            MessageBox.Show("button3_Click");            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //przygotowania (arrange)
            Ułamek u = new Ułamek();
            PrivateObject pou = new PrivateObject(u);
            pou.SetField("licznik", 2);
            pou.SetField("mianownik", 4);

            //działanie (act)
            //u.Uprość();
            pou.Invoke("Uprość");

            //weryfikacja (assert)
            int wynik_licznik = (int)pou.GetField("licznik");
            int wynik_mianownik = (int)pou.GetField("mianownik");
            Assert.AreEqual(1, wynik_licznik);
            Assert.AreEqual(2, wynik_mianownik);
        }

        private void button3_Click_1(object sender, EventArgs e)
        {
            MessageBox.Show("button3_Click_1");            
        }

        private void button4_Click(object sender, EventArgs e)
        {
            try
            {
                string s = "1//2";
                Ułamek u = Ułamek.Parse(s);
                MessageBox.Show(u.ToString());
            }
            catch(Exception exc)
            {
                MessageBox.Show(exc.Message + " (" + exc.InnerException.Message + ")");
            }
        }
    }
}
