﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Projekt
{
    public interface IUpraszczalny
    {
        void Uprość();
    }

    public struct Ułamek : IComparable<Ułamek>, IUpraszczalny
    {
        private int licznik, mianownik;

        public int Licznik
        {
            get
            {
                return licznik;
            }
            set
            {
                licznik = value;
            }
        }

        public int Mianownik
        {
            get
            {
                return mianownik;
            }
            set
            {
                if (value == 0) throw new DivideByZeroException("Mianownik ułamka zwykłego nie może być równy zeru");
                else mianownik = value;
            }
        }

        /*
        public Ułamek()
        {
            licznik = 0;
            mianownik = 1;
        }
        */

        public Ułamek(int licznik, int mianownik = 1)
        {
            this.licznik = licznik;
            this.mianownik = mianownik;
            Mianownik = mianownik;
            Uprość();
        }

        #region Konwersje
        public double ToDouble()
        {
            return (double)licznik / (double)mianownik;
        }

        public static explicit operator double(Ułamek u)
        {
            return u.ToDouble();
        }        

        public override string ToString()
        {
            return licznik.ToString() + "/" + mianownik.ToString();
        }

        public static implicit operator Ułamek(int n)
        {
            return new Ułamek(n);
        }
        #endregion

        public static readonly Ułamek Połowa = new Ułamek(1, 2);

        #region Operatory arytmetyczne
        public static Ułamek operator +(Ułamek u1, Ułamek u2)
        {
            Ułamek wynik = new Ułamek(
                u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik, 
                u1.Mianownik * u2.Mianownik);
            wynik.Uprość();
            return wynik;
        }

        public static Ułamek operator -(Ułamek u1, Ułamek u2)
        {
            Ułamek wynik = new Ułamek(
                u1.Licznik * u2.Mianownik - u2.Licznik * u1.Mianownik,
                u1.Mianownik * u2.Mianownik);
            wynik.Uprość();
            return wynik;
        }

        public static Ułamek operator -(Ułamek u1)
        {
            return new Ułamek(-u1.Licznik, u1.Mianownik);
        }

        public static Ułamek operator *(Ułamek u1, Ułamek u2)
        {
            Ułamek wynik = new Ułamek(
                u1.Licznik * u2.Licznik,
                u1.Mianownik * u2.Mianownik);
            wynik.Uprość();
            return wynik;
        }

        public static Ułamek operator /(Ułamek u1, Ułamek u2)
        {
            Ułamek wynik = new Ułamek(
                u1.Licznik * u2.Mianownik,
                u1.Mianownik * u2.Licznik);
            wynik.Uprość();
            return wynik;
        }
        #endregion

        public void Uprość()
        {
            int a = licznik;
            int b = mianownik;

            //NWD
            int c;
            while (b != 0)
            {
                c = a % b;
                a = b;
                b = c;
            }

            licznik /= a;
            mianownik /= a;

            //znaki
            if (licznik * mianownik < 0) licznik = -Math.Abs(licznik);
            else licznik = Math.Abs(licznik);
            mianownik = Math.Abs(mianownik);
        }

        #region Operatory porównania
        public static bool operator ==(Ułamek u1, Ułamek u2)
        {
            return (u1.ToDouble() == u2.ToDouble());
        }

        public static bool operator !=(Ułamek u1, Ułamek u2)
        {
            return !(u1 == u2);
        }

        public override bool Equals(object obj)
        {
            if(!(obj is Ułamek)) return false;
            else
            {
                Ułamek u = (Ułamek)obj;
                return this == u;
            }
        }

        public override int GetHashCode()
        {
            return licznik ^ mianownik;
        }

        public static bool operator <(Ułamek u1, Ułamek u2)
        {
            return (u1.ToDouble() < u2.ToDouble());
        }

        public static bool operator <=(Ułamek u1, Ułamek u2)
        {
            return (u1.ToDouble() <= u2.ToDouble());
        }

        public static bool operator >(Ułamek u1, Ułamek u2)
        {
            return (u1.ToDouble() > u2.ToDouble());
        }

        public static bool operator >=(Ułamek u1, Ułamek u2)
        {
            return (u1.ToDouble() >= u2.ToDouble());
        }
        #endregion

        public int CompareTo(Ułamek other)
        {
            return this.ToDouble().CompareTo(other.ToDouble());
        }

        public static Ułamek Parse(string s)
        {
            try
            {
                if (!s.Contains('/')) throw new Exception("Brak kreski ułamkowej");
                if (s.StartsWith("/")) throw new Exception("Brak licznika");
                if (s.EndsWith("/")) throw new Exception("Brak mianownika");
                int pozycjaKreski = s.IndexOf('/');

                string slicznik = s.Substring(0, pozycjaKreski);
                string smianownik = s.Substring(pozycjaKreski + 1);
                int licznik = 0, mianownik = 0;
                try
                {
                    licznik = int.Parse(slicznik);
                }
                catch(Exception exc)
                {
                    throw new Exception("Błąd parsowania licznika", exc);
                }
                try
                {
                    mianownik = int.Parse(smianownik);
                }
                catch (Exception exc)
                {
                    throw new Exception("Błąd parsowania mianownika", exc);
                }
                
                return new Ułamek(licznik, mianownik);
            }
            catch(Exception exc)
            {
                throw new Exception("Nieprawidłowy łańcuch", exc);
            }
        }
    }
}
