﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Płótno
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //ustawienia pozwalające uniknąć mrugania obszarów
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            g.Clear(Color.White);
            g.DrawRectangle(Pens.Green, 0, 0, g.ClipBounds.Width - 1, g.ClipBounds.Height - 1);
            g.DrawLine(Pens.BlueViolet, 100, 100, 200, 200);
            g.DrawLine(Pens.Green, 200, 200, 100, 300);
            g.DrawEllipse(Pens.Gold, 300, 100, 100, 100);
            g.FillEllipse(Brushes.BlanchedAlmond, 310, 110, 80, 80);

            float promień = trackBar1.Value;
            g.FillEllipse(Brushes.MidnightBlue, 210 - promień, 310 - promień, 2 * promień, 2 * promień);

            g.DrawString((sender as Control).Text, DefaultFont, Brushes.Red, 10, 10);
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            Refresh();
        }
    }
}
