﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace GradientProject
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
        }

        byte Lerp(byte wart1, byte wart2, float waga)
        {
            if (waga<0 || waga>1)
            {
                throw new ArgumentException("Waga ma nie odpowiednią wartość");
            }
            return (byte)(wart1 * waga + wart2 * (1 - waga));
        }

        Color Lerp(Color kolor1, Color kolor2, float waga)
        {
            byte r = Lerp(kolor1.R, kolor2.R, waga);
            byte g = Lerp(kolor1.G, kolor2.G, waga);
            byte b = Lerp(kolor1.B, kolor2.B, waga);
            return Color.FromArgb(r,g,b);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            //g.FillRectangle(new SolidBrush(colorGorny), 0, 0, 100, 100);
            //g.FillRectangle(new SolidBrush(colorDolny), 0, 300, 100, 100);
            for(int y = 0;y<ClientRectangle.Height;y++)
            {
                //Color color = Lerp( colorDolny,colorGorny,(float)y/ClientRectangle.Height);
                //Color color = Rozszerzenia.Lerp(colorDolny, colorGorny, (float)y / ClientRectangle.Height);
                Color color = colorDolny.Lerp(colorGorny, (float)y / ClientRectangle.Height);
                g.DrawLine(new Pen(color), 0, y, ClientRectangle.Width, y);
            }
        }

        Color colorGorny = Color.White;
        Color colorDolny = Color.Black;

        private void button1_Click(object sender, EventArgs e)
        {
            Color kolor = (sender == button1) ? colorGorny : colorDolny;
            colorDialog1.Color = kolor;
            if (colorDialog1.ShowDialog() == DialogResult.OK) 
                kolor = colorDialog1.Color;
            if (sender == button1) colorGorny = kolor;
            else colorDolny = kolor;

            //this.BackColor = kolor;
            Refresh();
        }
    }

    public static class Rozszerzenia
    {
        private static byte Lerp(byte wart1, byte wart2, float waga)
        {
            if (waga < 0 || waga > 1)
            {
                throw new ArgumentException("Waga ma nie odpowiednią wartość");
            }
            return (byte)(wart1 * waga + wart2 * (1 - waga));
        }

        public static Color Lerp(this Color kolor1, Color kolor2, float waga)
        {
            byte r = Lerp(kolor1.R, kolor2.R, waga);
            byte g = Lerp(kolor1.G, kolor2.G, waga);
            byte b = Lerp(kolor1.B, kolor2.B, waga);
            return Color.FromArgb(r, g, b);
        }
    }
}
