﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using AsystentZakupów;

namespace TestyJednostkowe
{
    [TestClass]
    public class AutoSumowanieTesty
    {
        [TestMethod]
        public void DodajTest()
        {
            //arrange
            decimal suma = 100;
            decimal kwota = 50;
            AutoSumowanie asystent = new AutoSumowanie(suma);

            //act
            asystent.Dodaj(kwota);

            //assert
            Assert.AreEqual(suma + kwota, asystent.Suma);
        }

        [TestMethod]
        public void DodajPętlaTest()
        {
            Random r = new Random();
            for(int i = 0; i<10000000; ++i)
            {
                //arrange
                decimal suma = 100;
                decimal kwota = r.Next(900);                
                AutoSumowanie asystent = new AutoSumowanie(suma);

                //act
                asystent.Dodaj(kwota);

                //assert
                Assert.AreEqual(suma + kwota, asystent.Suma);
            }
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void DodajKwotaExceptionTest()
        {
            //arrange
            decimal kwota = -50;
            AutoSumowanie asystent = new AutoSumowanie(0);

            //act
            asystent.Dodaj(kwota);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void DodajLimitExceptionTest()
        {
            //arrange
            decimal suma = 900;
            decimal kwota = 200;
            AutoSumowanie asystent = new AutoSumowanie(suma, 1000);

            //act
            asystent.Dodaj(kwota);
        }

        //sprawdzić konstruktor + własność
        //sprawdzić samą własność
        //sprawdzić sam konstruktor
        [TestMethod]
        public void KonstruktorSumaTest()
        {
            //arrange
            decimal suma = 900;
            
            //act
            AutoSumowanie asystent = new AutoSumowanie(suma);
            decimal actual = asystent.Suma;

            //assert
            Assert.AreEqual(suma, actual);
        }

        [TestMethod]
        public void KonstruktorTest()
        {
            //arrange
            decimal suma = 900;

            //act
            AutoSumowanie asystent = new AutoSumowanie(suma);
            PrivateObject po = new PrivateObject(asystent);
            decimal pis = (decimal)po.GetField("suma");

            //assert
            Assert.AreEqual(suma, pis);
        }
    }
}
