﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

//Ikona ze strony: http://findicons.com/search/color

namespace Kolory
{
    public partial class Form1 : Form
    {
        Properties.Settings s = Properties.Settings.Default;

        public Form1()
        {
            InitializeComponent();
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {            
            //panel1.BackColor = SystemColors.Desktop;
            //panel1.BackColor = Color.BlueViolet;
            panel1.BackColor = Color.FromArgb(
                trackBarR.Value,
                trackBarG.Value,
                trackBarB.Value);
            labelR.Text = trackBarR.Value.ToString();
            labelG.Text = trackBarG.Value.ToString();
            labelB.Text = trackBarB.Value.ToString();
            labelHex.Text = KolorHex();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            /*
            double krok = Opacity / 100;
            for(int i = 0; i < 100; ++i)
            {
                Opacity -= krok;
                System.Threading.Thread.Sleep(1);
            }
            */

            s.R = (byte)trackBarR.Value;
            s.G = (byte)trackBarG.Value;
            s.B = (byte)trackBarB.Value;
            s.Left = Left;
            s.Top = Top;
            s.Width = Width;
            s.Height = Height;
            s.Save();

            for (; Opacity > 0; Opacity -= 0.01) 
                System.Threading.Thread.Sleep(1);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (
                s.R == trackBarR.Value && 
                s.G == trackBarG.Value && 
                s.B == trackBarB.Value) return;            

            DialogResult dr = MessageBox.Show(
                    "Czy na pewno chcesz zamknąć aplikację?",
                    this.Text,
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);
            if(dr == DialogResult.No) e.Cancel = true;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            trackBarR.Value = 0;
            trackBarG.Value = 0;
            trackBarB.Value = 0;
            //panel1.BackColor = Color.Black;
            //trackBar1_Scroll(null, null);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBarR.Value = s.R;
            trackBarG.Value = s.G;
            trackBarB.Value = s.B;
            Left = s.Left;
            Top = s.Top;
            Width = s.Width;
            Height = s.Height;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            string hex = KolorHex();
            //MessageBox.Show(hex);
            Clipboard.SetText(hex);
        }

        private string KolorHex()
        {
            string hex = "#";
            hex += trackBarR.Value.ToString("X2");
            hex += trackBarG.Value.ToString("X2");
            hex += trackBarB.Value.ToString("X2");
            return hex;
        }
    }
}
