﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;
using System.Globalization;
using System.Threading;
using System.Resources;

// konkurs 1. try catch
// zapisywanie geometrii okna + sciezka do pliku
// private void
// rich text box
// kolorowanie slow kluczowych

// konkurs 2. przegladarka rysunkow .net

// konkurs wielopoziomowe undo // redo
// localizacja -> language, menu

namespace Notatnik {
   
   public partial class Form1 : Form {

      #region fields/constructor

      [DllImport("user32.dll")]
      public static extern bool LockWindowUpdate(IntPtr hwndLock);

      //private ComponentResourceManager formResources;
      private string filePath = "";
      private bool isTextChanged = false;
      private bool isRich = false;
      private int previousLength = 0;
      private string[] keyWords = new string[] { "public", "private",
         "namespace", "void", "using", "class", "string", "int", "bool",
         "byte", "if", "else", "region", "try", "catch", "finally" };

      private string previousText = "";
      private int previousPosition = 0;
      private int undoLimit = 20;
      private List<Edycja> contents;
      private List<Edycja> redo;
      private ComponentResourceManager formResources;

      public Form1() {

         formResources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));

         InitializeComponent();
         UstawTytulOkna();

         contents = new List<Edycja>();
         redo = new List<Edycja>();
      }

      #endregion

      #region file operations

      private void OpenContents(string fName = "") {

         string bladOdczytu = formResources.GetString("strBladOdczytu");
         

         try {
            if (string.IsNullOrEmpty(fName)) {
               openFileDialog.FileName = fName;
               openFileDialog.Title = formResources.GetString("openFileDialog.Title");
               openFileDialog.Filter = formResources.GetString("openFileDialog.Filter");
               DialogResult dg = openFileDialog.ShowDialog();
               if (dg == DialogResult.OK) {
                  filePath = openFileDialog.FileName;
               }
            }
            else {
               filePath = fName;
            }
            string fileExt = Path.GetExtension(filePath);

            switch (fileExt) {
                  case ".txt":
                     txtEditor.Lines = File.ReadAllLines(filePath);
                     txtEditor.ReadOnly = openFileDialog.ReadOnlyChecked;
                     isRich = false;
                     break;
                  case ".rtf":
                  case ".cs":
                     txtRichEditor.LoadFile(filePath);
                     txtRichEditor.ReadOnly = openFileDialog.ReadOnlyChecked;
                     isRich = true;
                     ProcessKeyWords();
                     break;
               }
               PokazEdytor();
               isTextChanged = false;
               UstawTytulOkna();
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, bladOdczytu,
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
      }

      private bool SaveContents() {

         string bladZapisu = formResources.GetString("strBladZapisu");
         //string tekstowe = "";
         //string rtf = "";

         try {
            saveFileDialog.FileName = filePath;
            saveFileDialog.Title = formResources.GetString("saveFileDialog.Title");
            saveFileDialog.Filter = formResources.GetString("saveFileDialog.Filter");

            switch (isRich) {
               case false:
                  saveFileDialog.DefaultExt = "txt";
                  //saveFileDialog.Filter = "Pliki tekstowe (*.txt)|*.txt";
                  break;
               case true:
                  saveFileDialog.DefaultExt = "rtf";
                  //saveFileDialog.Filter = "Pliki rtf (*.rtf)|*.rtf|Pliki C# (*.cs)|*.cs";
                  break;
            }

            DialogResult dg = saveFileDialog.ShowDialog();
            if (dg == DialogResult.OK) {
               filePath = saveFileDialog.FileName;
               switch (isRich) {
                  case true:
                     txtRichEditor.SaveFile(filePath);
                     break;
                  case false:
                     File.WriteAllLines(filePath, txtEditor.Lines);
                     break;
               }
               isTextChanged = false;
               UstawTytulOkna();
               return true;
            }
            else if (dg == DialogResult.No) {
               WyczyscEdytor();
            }
            else if (dg == DialogResult.Cancel)
               return false;
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, bladZapisu,
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         return false;
      }

      private bool Save() {
         string bladZapisu = formResources.GetString("strBladZapisu");
         try {
            if (File.Exists(filePath)) {
               switch (isRich) {
                  case true:
                     txtRichEditor.SaveFile(filePath);
                     break;
                  case false:
                     File.WriteAllLines(filePath, txtEditor.Lines);
                     break;
               }
               isTextChanged = false;
               UstawTytulOkna();
               return true;
            }
            else {
               bool exit = SaveContents();
               return exit;
            }
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, bladZapisu,
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         return false;
      }

      private bool SaveCurrent() {

         string czyZapisac = formResources.GetString("strZapiszBiezacy");
         string zapisywanie = formResources.GetString("strZapisywanie");

         if (isTextChanged == true) {
            DialogResult dg = MessageBox.Show(czyZapisac + "?", zapisywanie, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question);
            if (dg == DialogResult.Yes) {
               return Save();               
            }
            else if (dg == DialogResult.No) {
               WyczyscEdytor();
            }
            else if (dg == DialogResult.Cancel)
               return false;
         }
         return true;
      }

      #endregion

      #region menu formatowanie

      private void mnuWidokKolorTla_Click(object sender, EventArgs e) {
         DialogResult dg = colorDialog.ShowDialog();
         if (dg == DialogResult.OK) {
            switch (isRich) {
               case false:
                  txtEditor.BackColor = colorDialog.Color;
                  break;
               case true:
                  txtRichEditor.SelectionBackColor = colorDialog.Color;
                  break;
            }
         }
      }

      private void mnuWidokCzcionka_Click(object sender, EventArgs e) {
         DialogResult dg = fontDialog.ShowDialog();
         if (dg == DialogResult.OK) {
            switch (isRich) {
               case false:
                  txtEditor.Font = fontDialog.Font;
                  txtEditor.ForeColor = fontDialog.Color;
                  break;
               case true:
                  txtRichEditor.SelectionFont = fontDialog.Font;
                  txtRichEditor.SelectionColor = fontDialog.Color;
                  break;
            }
         }
      }

      private void mnuWidokZawijanieWierszy_Click(object sender, EventArgs e) {
         switch (isRich) {
            case false:
               txtEditor.WordWrap = mnuWidokZawijanieWierszy.Checked;
               break;
            case true:
               txtRichEditor.WordWrap = mnuWidokZawijanieWierszy.Checked;
               break;
         }
      }

      #endregion

      #region menu plik

      private void mnuPlikOtworz_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            OpenContents();
         }
      }

      private void mnuPlikZapiszJako_Click(object sender, EventArgs e) {
         SaveContents();
      }

      private void mnuPlikZakoncz_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true)
            this.Close();
      }

      private void mnuPlikZapisz_Click(object sender, EventArgs e) {
         Save();
      }

      private void mnuPlikNowy_Click(object sender, EventArgs e) {
         //SaveCurrent();
         //WyczyscEdytor();
      }

      private void mnuPlikNowyTxt_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            isRich = false;
            WyczyscEdytor();
            PokazEdytor();
         }
      }

      private void mnuPlikNowyRtf_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            isRich = true;
            WyczyscEdytor();
            PokazEdytor();
         }
      }

      #endregion

      #region edycja

      private void wytnijToolStripMenuItem_Click(object sender, EventArgs e) {
         if (isRich) {
            txtRichEditor.Cut();
         }
         else {
            txtEditor.Cut();
         }
      }

      private void kopiujToolStripMenuItem_Click(object sender, EventArgs e) {
         if (isRich) {
            txtRichEditor.Copy();
         }
         else {
            txtEditor.Copy();
         }

      }

      private void wklejToolStripMenuItem_Click(object sender, EventArgs e) {
         if (isRich) {
            txtRichEditor.Paste();
         }
         else {
            txtEditor.Paste();
         }

      }

      private void usunToolStripMenuItem_Click(object sender, EventArgs e) {
         if (isRich) {
            txtRichEditor.SelectedText = "";
         }
         else {
            txtEditor.SelectedText = "";
         }
      }

      private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e) {
         if (isRich) {
            txtRichEditor.SelectAll();
         }
         else {
            txtEditor.SelectAll();
         }
      }

      private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e) {

         //string godzinaData = DateTime.Now.ToString(System.Globalization.CultureInfo.InvariantCulture);
         //string godzinaData = DateTime.Now.ToString(System.Globalization.CultureInfo.CreateCulture("pl-PL");
         string godzinaData = DateTime.Now.ToString();
         if (isRich) {
            txtRichEditor.SelectedText = godzinaData;
         }
         else {
            txtEditor.SelectedText = godzinaData;
         }
      }

      private void UstawTytulOkna() {

         //string sciezkaPliku = "Nowy niezapisany plik";
         string sciezkaPliku = formResources.GetString("strNowyNiezapisany");
         string wTrybieEdycji = formResources.GetString("strWEdycji");
         string wTrybie = formResources.GetString("strWTrybie");
         string strNazwa  = formResources.GetString("$this.Text") + " .NET";

         if (!(string.IsNullOrEmpty(filePath)))
            sciezkaPliku = Path.GetFileName(filePath);
         this.Text = sciezkaPliku + " - " + strNazwa;
         if (isTextChanged)
            this.Text += " " + wTrybieEdycji;
         if (isRich)
            this.Text += " " + wTrybie + " RTF";

      }

      private void WyczyscEdytor() {
         filePath = "";
         txtEditor.Clear();
         txtRichEditor.Clear();
         contents.Clear();
         redo.Clear();
         isTextChanged = false;
         UstawTytulOkna();
      }

      private void cofnijToolStripMenuItem_Click(object sender, EventArgs e) {
         if (isRich)
            txtRichEditor.Undo();
         else
            txtEditor.Undo();
      }

      private void PokazEdytor() {
         if (isRich) {
            txtEditor.Visible = false;
            txtRichEditor.Visible = true;
         }
         else {
            txtEditor.Visible = true;
            txtRichEditor.Visible = false;
         }
      }

      #endregion

      #region highlight

      private void ProcessLineKeyWords(int lineNumber) {
         if (txtRichEditor.Text == string.Empty)
            return;

         int lineLength = txtRichEditor.Lines[lineNumber].Length;
         if (lineLength == 0)
            return;

         this.txtRichEditor.TextChanged -= this.txtRichEditor_TextChanged;
         LockWindowUpdate(txtRichEditor.Handle);
         txtRichEditor.WordWrap = false;

         int selectionStart = txtRichEditor.SelectionStart;
         int column = selectionStart - txtRichEditor.GetFirstCharIndexOfCurrentLine();
         string[] lineWords = txtRichEditor.Lines[lineNumber].Split(' ');
         int lineStart = selectionStart - column;
         int wordSelect = lineStart;

         foreach (string lineWord in lineWords) {
            foreach (string keyWord in keyWords) {
               txtRichEditor.SelectionStart = wordSelect;
               txtRichEditor.SelectionLength = lineWord.Length;

               if (lineWord == keyWord) {
                  txtRichEditor.SelectionColor = Color.Blue;
                  txtRichEditor.SelectionStart = lineStart + column;
                  txtRichEditor.SelectionLength = 0;
                  break;
               }
               else {
                  txtRichEditor.SelectionColor = Color.Black;
                  txtRichEditor.SelectionStart = lineStart + column;
                  txtRichEditor.SelectionLength = 0;
               }
            }
            wordSelect += lineWord.Length;
            wordSelect += 1;
         }
         LockWindowUpdate(IntPtr.Zero);
         this.txtRichEditor.TextChanged += this.txtRichEditor_TextChanged;
      }

      [Obsolete]
      private void ProcessKeyWords_() {
         if (txtRichEditor.Text == string.Empty)
            return;

         MessageBox.Show(txtRichEditor.Lines.Length.ToString());

         txtRichEditor.WordWrap = false;
         for (int i = 0; i < txtRichEditor.Lines.Length; i++)
            ProcessLineKeyWords(i);
      }

      private void ProcessKeyWords() {

         if (txtRichEditor.Text == string.Empty)
            return;

         this.txtRichEditor.TextChanged -= this.txtRichEditor_TextChanged;

         LockWindowUpdate(txtRichEditor.Handle);
         txtRichEditor.WordWrap = false;

         int selectionStart = txtRichEditor.SelectionStart;
         string content = txtRichEditor.Text;

         string[] contents = content.Split(new string[] { "\n" }, StringSplitOptions.None);
         int currentPosition = 0;

         foreach (string contentLine in contents) {

            string[] words = contentLine.Split(' ');

            foreach (string word in words) {
               currentPosition += word.Length;
               foreach (string keyword in keyWords) {
                  if (word == keyword) {
                     txtRichEditor.Select(currentPosition - word.Length, word.Length);
                     txtRichEditor.SelectionColor = Color.Blue;
                     break;
                  }
                  else {
                     txtRichEditor.Select(currentPosition - word.Length, word.Length);
                     txtRichEditor.SelectionColor = Color.Black;
                  }
               }
               currentPosition += 1;
            }
         }
         txtRichEditor.Select(selectionStart, 0);
         LockWindowUpdate(IntPtr.Zero);
         this.txtRichEditor.TextChanged += this.txtRichEditor_TextChanged;
      }

      #endregion

      #region multi undo

      private void ProcessRedo(object sender, EventArgs e) {

         if (isRich) {
            txtRichEditor.TextChanged -= txtRichEditor_TextChanged;
            if (redo.Count > 0) {
               if (contents.Count > undoLimit)
                  contents.RemoveAt(0);
               Edycja edycja = new Edycja();
               edycja.position = txtRichEditor.SelectionStart;
               edycja.textContent = txtRichEditor.Rtf;
               contents.Add(edycja);
               int lastPosition = redo.Count - 1;
               txtRichEditor.Clear();
               txtRichEditor.Rtf = redo[lastPosition].textContent;
               txtRichEditor.SelectionStart = redo[lastPosition].position;
               redo.RemoveAt(lastPosition);
               previousText = txtRichEditor.Rtf;
               previousPosition = txtRichEditor.SelectionStart;
            }
            txtRichEditor.TextChanged += txtRichEditor_TextChanged;
         }
         else {
            txtEditor.TextChanged -= txtEditor_TextChanged;
            if (redo.Count > 0) {
               if (contents.Count > undoLimit)
                  contents.RemoveAt(0);
               Edycja edycja = new Edycja();
               edycja.position = txtEditor.SelectionStart;
               edycja.textContent = txtEditor.Text;
               contents.Add(edycja);
               int lastPosition = redo.Count - 1;
               txtEditor.Clear();
               txtEditor.Text = redo[lastPosition].textContent;
               txtEditor.SelectionStart = redo[lastPosition].position;
               redo.RemoveAt(lastPosition);
               previousText = txtEditor.Text;
               previousPosition = txtEditor.SelectionStart;
            }
            txtEditor.TextChanged += txtEditor_TextChanged;
         }
      }

      private void ProcessUndo(object sender, EventArgs e) {

         if (isRich) {
            txtRichEditor.TextChanged -= txtRichEditor_TextChanged;
            if (contents.Count > 0) {
               Edycja edycja = new Edycja();
               edycja.position = txtRichEditor.SelectionStart;
               edycja.textContent = txtRichEditor.Rtf;
               redo.Add(edycja);
               int lastPosition = contents.Count - 1;
               txtRichEditor.Clear();
               txtRichEditor.Rtf = contents[lastPosition].textContent;
               txtRichEditor.SelectionStart = contents[lastPosition].position;
               contents.RemoveAt(lastPosition);
            }
            previousText = txtRichEditor.Rtf;
            previousPosition = txtRichEditor.SelectionStart;
            txtRichEditor.TextChanged += txtRichEditor_TextChanged;
         }
         else {
            txtEditor.TextChanged -= txtEditor_TextChanged;
            if (contents.Count > 0) {
               Edycja edycja = new Edycja();
               edycja.position = txtEditor.SelectionStart;
               edycja.textContent = txtEditor.Text;
               redo.Add(edycja);
               int lastPosition = contents.Count - 1;
               txtEditor.Clear();
               txtEditor.Text = contents[lastPosition].textContent;
               txtEditor.SelectionStart = contents[lastPosition].position;
               contents.RemoveAt(lastPosition);
            }
            previousText = txtEditor.Text;
            previousPosition = txtEditor.SelectionStart;
            txtEditor.TextChanged += txtEditor_TextChanged;
         }
      }

      private void AddToUndo() {
         if (contents.Count > undoLimit)
            contents.RemoveAt(0);

         Edycja edycja = new Edycja();
         edycja.position = previousPosition;
         edycja.textContent = previousText;
         contents.Add(edycja);

         if (isRich) {
            previousText = txtRichEditor.Rtf;
            previousPosition = txtRichEditor.SelectionStart;
         }
         else {
            previousText = txtEditor.Text;
            previousPosition = txtEditor.SelectionStart;
         }
      }

      #endregion

      #region form events

      private void SetStatus() {

         int selectionStart;
         int currentLine = 0;
         int column = 0;
         int length = 0;

         string strLinia = formResources.GetString("strLinia");
         string strKolumna = formResources.GetString("strKolumna");
         string strDlugosc = formResources.GetString("strDlugosc");

         if (isRich) {
            selectionStart = txtRichEditor.SelectionStart;
            currentLine = txtRichEditor.GetLineFromCharIndex(selectionStart);
            column = selectionStart - txtRichEditor.GetFirstCharIndexOfCurrentLine();
            length = txtRichEditor.Text.Length;
         }
         else {
            selectionStart = txtEditor.SelectionStart;
            currentLine = txtEditor.GetLineFromCharIndex(selectionStart);
            column = selectionStart - txtEditor.GetFirstCharIndexOfCurrentLine();
            length = txtEditor.Text.Length;
         }
         statusStripLabel.Text = strLinia + ": " + currentLine + " " + strKolumna + ": " + column + " " + strDlugosc + ": " + length;
      }



      private void txtEditor_TextChanged(object sender, EventArgs e) {
         
         isTextChanged = true;
         UstawTytulOkna();
         SetStatus();
         //int selectionStart = txtEditor.SelectionStart;
         //int currentLine = txtEditor.GetLineFromCharIndex(selectionStart);
         //int column = selectionStart - txtEditor.GetFirstCharIndexOfCurrentLine();

         //string strLinia = formResources.GetString("strLinia");
         //string strKolumna = formResources.GetString("strKolumna");
         //string strDlugosc = formResources.GetString("strDlugosc");

         //statusStripLabel.Text = strLinia + ": " + currentLine + " " + strKolumna + ": " + column + " " + strDlugosc + ": " + txtEditor.Text.Length;

         redo.Clear();
         AddToUndo();

      }

      private void txtRichEditor_TextChanged(object sender, EventArgs e) {

         isTextChanged = true;
         UstawTytulOkna();
         int selectionStart = txtRichEditor.SelectionStart;
         int currentLength = txtRichEditor.TextLength;
         int currentLine = txtRichEditor.GetLineFromCharIndex(selectionStart);
         int column = selectionStart - txtRichEditor.GetFirstCharIndexOfCurrentLine();

         if (currentLength > (previousLength + 1))
            ProcessKeyWords();
         else
            ProcessLineKeyWords(currentLine);
         previousLength = currentLength;

         SetStatus();

         //string strLinia = formResources.GetString("strLinia");
         //string strKolumna = formResources.GetString("strKolumna");
         //string strDlugosc = formResources.GetString("strDlugosc");

         //statusStripLabel.Text =  strLinia + ": " + currentLine + " " + strKolumna + ": " + column + " " + strDlugosc + ": " + txtRichEditor.Text.Length;

         redo.Clear();
         AddToUndo();

      }

      private void Form1_FormClosing(object sender, FormClosingEventArgs e) {
         bool exit = SaveCurrent();
         if (exit == false)
            e.Cancel = true;
      }

      private void Form1_FormClosed(object sender, FormClosedEventArgs e) {
         Properties.Settings.Default.FilePath = filePath;
         Properties.Settings.Default.Left = this.Left;
         Properties.Settings.Default.Top = this.Top;
         Properties.Settings.Default.Width = this.Width;
         Properties.Settings.Default.Height = this.Height;
         Properties.Settings.Default.Save();
      }

      private void Form1_Load(object sender, EventArgs e) {
         
         this.Left = Properties.Settings.Default.Left;
         this.Top = Properties.Settings.Default.Top;
         this.Width = Properties.Settings.Default.Width;
         this.Height = Properties.Settings.Default.Height;

         string fileFromProperties = Properties.Settings.Default.FilePath;
         if (File.Exists(fileFromProperties)) {
            filePath = fileFromProperties;
            OpenContents(filePath);
         }
      }

      #endregion

      private void WyczyscMenuJezyk() {
         foreach (ToolStripMenuItem itm in mnuJezyk.DropDownItems)
            itm.Checked = false;
      }

      private void jezykMenuItemClick(object sender, EventArgs e) {
         WyczyscMenuJezyk();

         ToolStripMenuItem eventMenu = (ToolStripMenuItem)sender;
         string wybor = eventMenu.Tag.ToString();
         CultureInfo cInfo = new CultureInfo(wybor);

         SetLanguage(this, cInfo);

         eventMenu.Checked = true;     

      }

      private void SetLanguage( Form form, CultureInfo lang) {

         System.Threading.Thread.CurrentThread.CurrentUICulture = lang;
         ApplyResourceToMenu(formResources, form.MainMenuStrip, lang);
         ApplyResourceToMenu(formResources, form.ContextMenuStrip, lang);
         //form.Text = formResources.GetString("$this.Text", lang) + " .NET";
         UstawTytulOkna();
         SetStatus();
      }

      private void ApplyResourceToMenu(ComponentResourceManager resources, MenuStrip menu, CultureInfo lang) {
         foreach (ToolStripMenuItem m in menu.Items) {
            
            string text = resources.GetString(m.Name + ".Text", lang);
            if (text != null)
               m.Text = text;

            foreach (ToolStripItem d in m.DropDownItems) {
               text = resources.GetString(d.Name + ".Text", lang);
               if (text != null)
                  d.Text = text;
            }
         }
      }

      private void ApplyResourceToMenu(ComponentResourceManager resources, ContextMenuStrip menu, CultureInfo lang) {
         foreach (ToolStripItem m in menu.Items) {

            string text = resources.GetString(m.Name + ".Text", lang);
            if (text != null)
               m.Text = text;
         }
      }



      public class Edycja {

         public string textContent;
         public int position;

      }

            
   }
}
