﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsNotatnik
{
    public partial class Form1 : Form
    {
        Properties.Settings settings = Properties.Settings.Default;
        string sciezkaPliku = "";
        bool tekstZmieniony = false;
        List<String> magazynPisania = new List<string>();
        int indeksUndo;

        public Form1()
        {
            InitializeComponent();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = "";
            sciezkaPliku = "";
            tekstZmieniony = false;
            ustalTytulOkna();
            resetMagazynuPisania();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = Path.GetFileName(sciezkaPliku);
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
                        richTextBox1.LoadFile(openFileDialog1.FileName, RichTextBoxStreamType.RichText);
                    else
                        richTextBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                    resetMagazynuPisania();
                        
                    sciezkaPliku = openFileDialog1.FileName;
                    tekstZmieniony = false;
                    ustalTytulOkna();
                }
            }
            catch (Exception exc)
            {

                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
            
        }

        private void resetMagazynuPisania()
        {
            indeksUndo = 0;
            magazynPisania.Add(richTextBox1.Text);
        }

        private void ustalTytulOkna()
        {
            this.Text = Path.GetFileName(sciezkaPliku) +
                (tekstZmieniony ? "*" : "") +
                " - Notatnik.NET";
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
                zapiszDoPliku();
        }

        private bool zapiszDoPliku()
        {
            try
            {
                if (!File.Exists(sciezkaPliku)) return zapiszDoPlikuJako();
                else
                {
                    File.WriteAllLines(sciezkaPliku, richTextBox1.Lines);
                    tekstZmieniony = false;
                    ustalTytulOkna();
                    return true;
                }
            }
            catch (Exception exc)
            {

                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszDoPlikuJako();
        }

        private bool zapiszDoPlikuJako()
        {
            try
            {
                if (File.Exists(sciezkaPliku))
                {
                    saveFileDialog1.InitialDirectory = Path.GetDirectoryName(sciezkaPliku);
                    saveFileDialog1.FileName = Path.GetFileName(sciezkaPliku);
                }
                else
                {
                    saveFileDialog1.FileName = "";
                }
                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    richTextBox1.ReadOnly = false;
                    File.WriteAllLines(saveFileDialog1.FileName, richTextBox1.Lines);
                    sciezkaPliku = saveFileDialog1.FileName;
                    tekstZmieniony = false;
                    ustalTytulOkna();
                    return true;
                }
                else
                    return false;
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
            
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) Close();
            else if (spytajCzyZapisac()) Close();
        }

        private bool spytajCzyZapisac()
        {
            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku" + sciezkaPliku + "?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question);
            switch (dr)
            {
                case DialogResult.Yes:
                    return zapiszDoPliku();
                case DialogResult.No:
                    return true;
                case DialogResult.Cancel:
                    return false;
                default:
                    throw new Exception("Nieprzewidziana wartość zmiennej 'dr'");
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
            {
                fontDialog1.Font = richTextBox1.SelectionFont;
                fontDialog1.Color = richTextBox1.SelectionColor;
            }
            else
            {
                fontDialog1.Font = richTextBox1.Font;
                fontDialog1.Color = richTextBox1.ForeColor;
            }
 
            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
                {
                    richTextBox1.SelectionFont = fontDialog1.Font;
                    richTextBox1.SelectionColor = fontDialog1.Color;
                }
                else
                {
                    richTextBox1.Font = fontDialog1.Font;
                    richTextBox1.ForeColor = fontDialog1.Color;
                }
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = richTextBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                richTextBox1.BackColor = colorDialog1.Color;
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            settings.formLeft = this.Left;
            settings.formTop = this.Top;
            settings.formWidth = this.Width;
            settings.formHeight = this.Height;
            settings.sciezkaPliku = sciezkaPliku;
            settings.Save();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Height = settings.formHeight;
            Width = settings.formWidth;
            Left = settings.formLeft;
            Top = settings.formTop;
            if (File.Exists(settings.sciezkaPliku))
            {
                sciezkaPliku = settings.sciezkaPliku;
            }
            
        }

        private void richTextBox1_TextChanged(object sender, EventArgs e)
        {
            tekstZmieniony = true;
            ustalTytulOkna();
        }

        private void słowaKluczoweCToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string[] slowaKluczowe = { "abstract", "event", "new", "struct",
                "as", "explicit", "null", "switch", "base", "extern", "object", "this", "bool", "false",
                "operator", "throw", "break", "finally", "out", "true", "byte", "fixed", "override", "try",
                "case", "float", "params", "typeof", "catch", "for", "private", "uint", "char", "foreach",
                "protected", "ulong", "goto", "public", "unchecked", "class", "if",
                "unsafe", "const", "implicit", "ref", "ushort", "continue", "in", "return", "using",
                "decimal", "int", "sbyte", "virtual", "default", "interface", "sealed", "volatile", "delegate",
                "internal", "short", "void", "do", "is", "sizeof", "while", "double", "lock", "stackalloc",
                "else", "long", "static", "enum", "namespace", "string", "readonly", "checked" };
            foreach (var item in slowaKluczowe)
            {
                int index = 0;
                while (index <= richTextBox1.Text.LastIndexOf(item))
                {
                    richTextBox1.Find(item, index, RichTextBoxFinds.WholeWord);
                    richTextBox1.SelectionColor = Color.Red;
                    index = richTextBox1.Text.IndexOf(item, index) + 1;
                    richTextBox1.Select();
                }
                          
            }
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (indeksUndo > 0) indeksUndo--;
            richTextBox1.Text = magazynPisania[indeksUndo];
            if (indeksUndo == 0) richTextBox1.Text = "";
        }

        private void richTextBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Space)
            {
                magazynPisania.Add(richTextBox1.Text);
                indeksUndo++;
            }
            toolStripStatusLabel1.Text = indeksUndo.ToString();
        }

        private void ponówToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (indeksUndo < magazynPisania.Count) indeksUndo++;
            if (indeksUndo >= magazynPisania.Count) indeksUndo = magazynPisania.Count - 1;
            richTextBox1.Text = magazynPisania[indeksUndo];
        }
    }
}
