﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Studium_1
{
    public partial class frm : Form
    {
        private string ofdLastFile = string.Empty;
        private bool teksZmieniony = true;
        private StringBuilder sb = new StringBuilder();
        private string[] slOper = new string[]{"abstract","as","base","break","case","catch","checked","continue","default","delegate","do","else","event","explicit","extern","false","finally","fixed","for","foreach","goto","if","implicit","in","interface","internal","is","lock","namespace","new","null","object","operator","out","override","params","private","protected","partial","public","readonly","ref","return","sealed","sizeof","stackalloc","switch","this","throw","true","try","typeof","unchecked","unsafe","using","virtual","while"};
        private string[] slType = new string[]{"bool","byte","char","class","const","decimal","double","enum","float","int","long","sbyte","short","static","string","struct","uint","ulong","ushort","void","StringBuilder","EventArgs"};
        private string[] slPointer = new string[] { "[", "]", "(", ")", "{", "}", "*", "&", "|", "!" };
        private string[] slComa = new string[] { "[", "]", "(", ")", "{", "}", "*", "&", "|", "!", ",", ":", ";", "!", " ", "=", "."};
        public frm()
        {
            InitializeComponent();
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                ofd.FileName = ofdLastFile;
                if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    ofdLastFile = ofd.FileName;
                    tb.ReadOnly = ofd.ReadOnlyChecked;
                    tb.Lines = File.ReadAllLines(ofd.FileName);
                    teksZmieniony = false;
                    ustalTytulOkna();
                    if (Path.GetExtension(ofdLastFile).Equals(".cs"))
                        doCSharp();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd odczytu: " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void doCSharp()
        {
            sb = new StringBuilder();
            foreach (string s in tb.Lines)
                sb.AppendLine(s);
            sb.Replace("\r\n", "\\par\r\n");
            foreach (string s in slOper.OrderByDescending(q => q.Length).ToArray())
                foreach(string s2 in slComa)
                    sb.Replace(s + s2, string.Format("\\cf2 {0}\\cf0 ", s + s2));
            foreach (string s in slType.OrderByDescending(q => q.Length).ToArray())
                foreach (string s2 in slComa)
                    sb.Replace(s + s2, string.Format("\\cf1 {0}\\cf0 ", s + s2));
            foreach (string s in slPointer)
                sb.Replace(s, string.Format("\\cf3 {0}\\cf0 ", s));
            sb.Replace("{", "\\{").Replace("}", "\\}");
            sb.Insert(0, "{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0\\fnil\\fcharset238 Microsoft Sans Serif;}}\r\n{\\colortbl ;\\red0\\green128\\blue0;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}\r\n\\viewkind4\\uc1\\pard\\cf1\\lang1045\\f0\\fs17");
            rtb.Rtf = sb.ToString();
        }

        private string ustalTytulOkna()
        {
            return this.Text = Path.GetFileName(ofdLastFile) + (teksZmieniony ? "*" : "") + " - Notatnik";
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszPlik(sender, e);
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                cd.Color = tb.BackColor;
                cd.AllowFullOpen = true;
                if (cd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    tb.BackColor = cd.Color;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd : " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                fd.Font = tb.Font;
                fd.Color = tb.ForeColor;
                if (fd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    tb.Font = fd.Font;
                    tb.ForeColor = fd.Color;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd : " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszPlik(sender, e);
        }

        private void zapiszPlik(object sender, EventArgs e)
        {
            try
            {
                teksZmieniony = false;
                if (!File.Exists(ofdLastFile))
                    zapiszJakoDoPliku(sender, e);
                else
                    File.WriteAllLines(ofdLastFile, tb.Lines);
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error
                    );
            }
        }

        private void zapiszJakoDoPliku(object sender, EventArgs e)
        {
            try
            {
                sfd.InitialDirectory = Path.GetDirectoryName(ofd.FileName);
                sfd.FileName = Path.GetFileName(ofdLastFile);
                if (sfd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    tb.ReadOnly = false;
                    ofdLastFile = sfd.FileName;
                    File.WriteAllLines(sfd.FileName, tb.Lines);
                    ustalTytulOkna();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd zapisu: " + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!teksZmieniony)
                wyczyscNotatnik();
            else
            {
                DialogResult dr = MessageBox.Show("Czy chcesz zapisać zmiany w pliku  " + ofdLastFile + "?", this.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                switch (dr)
                {
                    case DialogResult.Yes:
                        zapiszJakoDoPliku(null, null);
                        wyczyscNotatnik();

                        break;
                    case DialogResult.No:
                        wyczyscNotatnik();
                        break;
                    case DialogResult.Cancel:
                        break;
                }
            }
        }

        private void wyczyscNotatnik()
        {
            tb.Text = "";
            ofdLastFile = "";
            teksZmieniony = false;
            ustalTytulOkna();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.Cut();
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.Undo();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tb.SelectAll();
        }

        private void godzinadataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string gd = DateTime.Now.ToString(CultureInfo.CreateSpecificCulture("fr-FR"));
        }

        DateTime czasOstatniegoPomiar = DateTime.MaxValue;

        private void tb_TextChanged(object sender, EventArgs e)
        {
            double predkosc = 1 / (DateTime.Now - czasOstatniegoPomiar).TotalSeconds;
            ss.Text = "Liczba znaków: " + tb.Text.Count() + ", prędkość: " + predkosc.ToString("N2");
        }
    }
}
