﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace PadaSnieg
{
    public partial class Form1 : Form
    {
        const double proporcje = 1.3;
        const int szybkoscSniegu = 50;
        const int skalaSniezynek=600;
        Rectangle[] sniezynki;
        Random ran = new Random();
        bool dzien = true, miganie = true;
        Color kolorDzien = Color.CornflowerBlue;
        Color kolorNoc = Color.Black;
        Color kolorNiebo = Color.CornflowerBlue;
        int ySlonce;

        public Form1()
        {
            InitializeComponent();
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            InicjujSnieg(500);
            InicjujSlonce();
        }

        
        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            Tlo(g);
            RysujBalwana(g);
            RysujChoinke(g);
            RysujSnieg(g);
        }

        private void InicjujSlonce()
        {
            ySlonce = this.ClientRectangle.Height / 7;
        }
        private void Tlo(Graphics g)
        {
            int prop = 15; //16 - równo z dołem pnia
            g.FillRectangle(new SolidBrush(kolorNiebo), 0, 0, this.ClientRectangle.Width, this.ClientRectangle.Height);
            int wys = this.ClientRectangle.Height / prop;
            wys *= prop - 1;
            SlonceKsiezyc(g);
            g.FillRectangle(new SolidBrush(Color.White), 0, wys, this.ClientRectangle.Width, this.ClientRectangle.Height-wys);
        }

        private void RysujBalwana(Graphics g)
        {
            int szerPlotna = this.ClientRectangle.Width;
            int wysPlotna = this.ClientRectangle.Height;
            int sred = wysPlotna / 5;
            int y = wysPlotna / 8 * 6;
            for (int i = 0; i < 3; i++)
            {
                int x = (szerPlotna / 3) - (sred / 2);
                Rectangle balwan = new Rectangle(x, y, sred, sred);
                g.FillEllipse(new SolidBrush(Color.White), balwan);
                if (i == 1)
                {
                    Pen reka = new Pen(Color.Black, sred / 24);
                    //reka lewa
                    g.DrawLine(reka, x + sred / 8, y + sred / 2, x - sred / 6, y +sred/8);
                    g.DrawLine(reka, x - sred / 6, y + sred / 8, x - sred / 4, y - sred / 8);
                    g.DrawLine(reka, x - sred / 6, y + sred / 8, x - sred / 3, y + sred / 8);
                    //reka prawa
                    g.DrawLine(reka, x + sred, y + sred / 2, x + sred + sred / 6, y+sred/8);
                    g.DrawLine(reka, x + sred + sred / 6, y + sred / 8, x + sred+sred/10, y - sred / 8);
                    g.DrawLine(reka, x + sred + sred / 6, y + sred / 8, x + sred + sred / 3, y - sred/10);
                }
                if (i == 2)
                {
                    //"twarz"
                    g.FillEllipse(new SolidBrush(Color.Black), x + sred / 3, y + sred / 3, sred / 12, sred / 12);
                    g.FillEllipse(new SolidBrush(Color.Black), x + sred / 3 * 2, y + sred / 3, sred / 12, sred / 12);
                    Point[] trojkat = { new Point(x+sred/2+sred/16, y+sred/2), new Point(x + sred / 2 + sred /16, y + sred/2+sred/8), new Point(x + sred/2+sred/5, y+sred/2+sred/8) };
                    g.FillPolygon(new SolidBrush(Color.OrangeRed), trojkat);
                    Pen usmiech = new Pen(Color.Black, sred / 20);
                    usmiech.DashPattern =new float [] { 1f,1f};
                    g.DrawArc(usmiech, x +sred/4+sred/16, y +sred/2, sred/2, sred/3, 0, 180);
                }
                sred = (int)(sred / proporcje);
                y -= sred - (sred / 4);
            }
            

        }
            
        private void InicjujSnieg(int ileSniegu)
        {
            sniezynki = new Rectangle[ileSniegu];
            int x, y, s;
            for (int i = 0; i < ileSniegu; i++)
            {
                x = ran.Next(skalaSniezynek);
                y = ran.Next(skalaSniezynek);
                s = ran.Next(4)+1;
                sniezynki[i] = new Rectangle(x, y, s, s);
            }
        }
        private void RysujSnieg(Graphics g)
        {
            for (int i = 0; i < sniezynki.Length; i++)
            {
                double x = sniezynki[i].X * (this.ClientRectangle.Width/ (double)skalaSniezynek);
                double y = sniezynki[i].Y * (this.ClientRectangle.Height/ (double)skalaSniezynek);
                g.FillEllipse(new SolidBrush(Color.White),(int)x,(int)y,sniezynki[i].Width,sniezynki[i].Height);
               
            }
        }

        private void RysujChoinke(Graphics g)
        {
            int szerPlotna = this.ClientRectangle.Width;
            int wysPlotna = this.ClientRectangle.Height;
            int szer = szerPlotna / 4;
            int bombki = szer / 24;
            int y = wysPlotna / 8 * 7;
            int x = szerPlotna / 3 * 2 - szer / 16;
            Pen swiatelka = new Pen(Color.White, bombki/2);
            float[] wzorek = { 1f, 1f };
            swiatelka.DashPattern = wzorek;
            g.FillRectangle(new SolidBrush(Color.SaddleBrown), x, y, szer/8, wysPlotna / 16);
            for (int i = 0; i < 5; i++)
            {
                x = (szerPlotna / 3 * 2) - (szer / 2);
                Point[] trojkat = { new Point(x, y), new Point(x + szer / 2, y - wysPlotna / 9), new Point(x + szer, y) };
                g.FillPolygon(new SolidBrush(Color.Green), trojkat);
                g.FillEllipse(new SolidBrush(Color.Red), x - bombki / 2 + szer / 4, y - bombki / 2, bombki, bombki);
                g.FillEllipse(new SolidBrush(Color.Yellow), x + szer/4*3 - bombki / 2, y - bombki / 2, bombki, bombki);
                if (miganie)
                    swiatelka.Color = Color.Red;
                else
                    swiatelka.Color = Color.Blue;
                if (!dzien)
                    g.DrawArc(swiatelka,x-szer/1.4f, y-wysPlotna/8, szer*1.4f, wysPlotna/8,0,90);
                szer = (int)(szer / proporcje);
                y -= wysPlotna / 9 - wysPlotna / 36;
            }
           



        }

        private void SlonceKsiezyc(Graphics g)
        {
            if (dzien)
                RysujSlonce(g);
            else
                RysujKsiezyc(g);
        }

        private void RysujSlonce(Graphics g)
        {
            int srednica = this.ClientRectangle.Height / 7;
            int x = (int)(this.ClientRectangle.Width * 0.75);
            g.FillEllipse(new SolidBrush(Color.Gold), x , ySlonce, srednica, srednica);
            g.DrawLine(new Pen(Color.Gold,srednica/10), x + srednica / 2, ySlonce - srednica / 8, x + srednica / 2, (int)(ySlonce + srednica * 1.125));
            g.DrawLine(new Pen(Color.Gold, srednica / 10), x - srednica/8, ySlonce + srednica / 2, (int)(x + srednica*1.125), ySlonce + srednica /2);
            g.DrawLine(new Pen(Color.Gold, srednica / 10), x+srednica/16, ySlonce + srednica / 16, x + srednica - srednica/16, ySlonce+srednica-srednica/16);
            g.DrawLine(new Pen(Color.Gold, srednica / 10), x + srednica / 16, ySlonce - srednica / 16 + srednica, x + srednica - srednica / 16, ySlonce + srednica / 16);

        }

        private void RysujKsiezyc(Graphics g)
        {
            int srednica = this.ClientRectangle.Height / 7;
            int x = (int)(this.ClientRectangle.Width * 0.75);
            g.FillEllipse(new SolidBrush(Color.White), x ,ySlonce, srednica, srednica);
            g.FillEllipse(new SolidBrush(Color.Black), x+srednica/4, ySlonce-srednica/4, (int)(srednica*1.5d), (int)(srednica*1.5d));

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            bkgSnieg.RunWorkerAsync();
            bkgMiganie.RunWorkerAsync();
        }

        private void bkgSnieg_DoWork(object sender, DoWorkEventArgs e)
        {
            try {
                while (true)
                {
                    for (int i = 0; i < sniezynki.Length; i++)
                    {
                        sniezynki[i].Y += ran.Next(2)+1;
                        if (sniezynki[i].Y > skalaSniezynek)
                            sniezynki[i].Y -= skalaSniezynek;
                    }
                    System.Threading.Thread.Sleep(szybkoscSniegu);
                    this.Invoke(new Action(() => Refresh()));
                }
            }
            catch { }
        }

        private void bkgDzienNoc_DoWork(object sender, DoWorkEventArgs e)
        {
            for (int i = 0; i < 68; i++)
            {
                ySlonce = ySlonce + (int)e.Argument/4;
                System.Threading.Thread.Sleep(5);
            }
            System.Threading.Thread.Sleep(300);
            if (dzien)
            {
                
                for (int i = 0; i < 30; i++)
                {
                    int r = (int)(Color.Black.R * (i / 30d) + Color.CornflowerBlue.R * (1d - i / 30d));
                    int g = (int)(Color.Black.G * (i / 30d) + Color.CornflowerBlue.G * (1d - i / 30d));
                    int b = (int)(Color.Black.B * (i / 30d) + Color.CornflowerBlue.B * (1d - i / 30d));
                    kolorNiebo = Color.FromArgb(r, g, b);
                    System.Threading.Thread.Sleep(10);
                }
                dzien = false;
            }
            else
            {
                for (int i = 0; i < 30; i++)
                {
                    int r = (int)(Color.CornflowerBlue.R * (i / 30d) + Color.Black.R * (1d - i / 30d));
                    int g = (int)(Color.CornflowerBlue.G * (i / 30d) + Color.Black.G * (1d - i / 30d));
                    int b = (int)(Color.CornflowerBlue.B * (i / 30d) + Color.Black.B * (1d - i / 30d));
                    kolorNiebo = Color.FromArgb(r, g, b);
                    System.Threading.Thread.Sleep(10);
                    
                }
                dzien = true;
            }
            for (int i = 0; i < 72; i++)
            {
                ySlonce = ySlonce - (int)e.Argument / 4;
                System.Threading.Thread.Sleep(5);
            }
            for (int i = 0; i<2; i++)
            {
                ySlonce = ySlonce + (int)e.Argument / 2;
                System.Threading.Thread.Sleep(12);
            }
            //System.Threading.Thread.Sleep(300);
        }

        private void btnNoc_Click(object sender, EventArgs e)
        {
            if (dzien)
            {
                //dzien = false;
                if (!bkgDzienNoc.IsBusy)
                    bkgDzienNoc.RunWorkerAsync(this.ClientRectangle.Height/16);

            }
        }

        private void bkgMiganie_DoWork(object sender, DoWorkEventArgs e)
        {
            while (true)
            {
                miganie = !miganie;
                System.Threading.Thread.Sleep(750);
            }
        }




        private void btnDzien_Click(object sender, EventArgs e)
        {
            if (!dzien)
            {
                //dzien = true;
                if (!bkgDzienNoc.IsBusy)
                    bkgDzienNoc.RunWorkerAsync(this.ClientRectangle.Height / 16);
            }
        }
    }
}
