﻿using System.Drawing;
using System.Windows.Forms;
using System;
using System.Threading;
using System.Media;

namespace WindowsFormsBalwanek
{
    public partial class Form1 : Form
    {
        int szer, wys;
        Graphics g;
        int iloscPlatkow = 1200;
        float procentTylnychPlatkow = 0.55F;
        int[] sniegTlaX, sniegTlaY, sniegFrontX, sniegFrontY;
        int iloscPlatkowWTle, iloscPlatkowFront;
        static Random r = new Random();

        public Form1()
        {
            InitializeComponent();
            szer = ClientRectangle.Width;
            wys = ClientRectangle.Height;
            losowanieWspolrzednych();

            //ustawienia pozwalające uniknąć mrugania obszarów
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            g = e.Graphics;

            rysujTlo(e);
            sniegWTle(e);
            rysujChoinke(300, 380, e);
            rysujChoinke(80, 420, e);
            rysujChoinke(690, 360, e);
            rysujBalwanek(e);
            rysujChoinke(210, 500, e);
            rysujChoinke(420, 470, e);
            rysujChoinke(730, 530, e);
            sniegFront(e);
        }

        private void losowanieWspolrzednych()
        {
            iloscPlatkowWTle = (int)(iloscPlatkow * procentTylnychPlatkow);
            sniegTlaX = new int[iloscPlatkowWTle];
            sniegTlaY = new int[iloscPlatkowWTle];

            for (int i = 0; i < iloscPlatkowWTle; i++)
            {
                sniegTlaX[i] = r.Next(szer);
                sniegTlaY[i] = r.Next(wys - 200);
            }

            iloscPlatkowFront = iloscPlatkow - iloscPlatkowWTle;
            sniegFrontX = new int[iloscPlatkowFront];
            sniegFrontY = new int[iloscPlatkowFront];

            for (int i = 0; i < iloscPlatkowFront; i++)
            {
                sniegFrontX[i] = r.Next(szer);
                sniegFrontY[i] = r.Next(wys);
            }
        }

        private void rysujTlo(PaintEventArgs e)
        {
            SolidBrush kolorNieba = new SolidBrush(Color.DarkSlateBlue);
            g.FillRectangle(kolorNieba, 0, 0, szer, wys);
            g.FillRectangle(Brushes.Silver, 0, wys - 200, szer, wys);
            g.FillEllipse(Brushes.LightGoldenrodYellow, szer - 170, wys - 510, 120, 120); //ksiezyc
            g.FillEllipse(kolorNieba, szer - 215, wys - 495, 120, 120);
        }

        private void rysujBalwanek (PaintEventArgs e)
        {
            SolidBrush balwan = new SolidBrush(Color.WhiteSmoke);
            g.FillEllipse(balwan, szer - 300, wys - 240, 150, 150); //dolna kula
            g.FillEllipse(balwan, szer - 275, wys - 310, 100, 100); //srodkowa kula
            g.FillEllipse(balwan, szer - 263, wys - 360, 75, 75); //gorna kula
            g.FillPie(Brushes.OrangeRed, szer - 360, wys - 350, 120, 120, 330, 12); //nos
            g.FillEllipse(Brushes.Black, szer - 250, wys - 340, 10, 10);
            g.FillEllipse(Brushes.Black, szer - 225, wys - 330, 10, 10);
        }
        private void rysujChoinke(int x, int y, PaintEventArgs e)
        {
            int choX = x;
            int choY = y;
            Point[] tr1 = { new Point(choX, choY - 120), new Point(choX + 100, choY), new Point(choX - 100, choY) };
            Point[] tr2 = { new Point(choX, choY - 150), new Point(choX + 80, choY - 50), new Point(choX - 80, choY - 50) };
            Point[] tr3 = { new Point(choX, choY - 180), new Point(choX + 60, choY - 100), new Point(choX - 60, choY - 100) };
            Point[] tr4 = { new Point(choX, choY - 210), new Point(choX + 40, choY - 150), new Point(choX - 40, choY - 150) };
            g.FillPolygon(Brushes.DarkGreen, tr1);
            g.FillPolygon(Brushes.Green, tr2);
            g.FillPolygon(Brushes.ForestGreen, tr3);
            g.FillPolygon(Brushes.GreenYellow, tr4);
            g.FillRectangle(Brushes.SaddleBrown, choX - 5, choY, 10, 40);
        }

        private void timer1_Tick(object sender, System.EventArgs e)
        {
            for (int i = 0; i < iloscPlatkowWTle; i++)
            {
                sniegTlaY[i] += 2;
                if (sniegTlaY[i] >= (wys - 200))
                {
                    sniegTlaY[i] = 0;
                    sniegTlaX[i] = r.Next(szer);
                }
                    
                sniegTlaX[i] += 1;
                if (sniegTlaX[i] >= szer)
                {
                    sniegTlaX[i] = 0;
                    sniegTlaY[i] = r.Next(wys);
                }
                Invalidate();
            }

            for (int i = 0; i < iloscPlatkowFront; i++)
            {
                sniegFrontY[i] += 6;
                if (sniegFrontY[i] >= wys)
                {
                    sniegFrontY[i] = 0;
                    sniegFrontX[i] = r.Next(szer);
                }
                    
                sniegFrontX[i] += 3;
                if (sniegFrontX[i] >= szer)
                {
                    sniegFrontX[i] = 0;
                    sniegFrontY[i] = r.Next(wys);
                }
                Invalidate();
            }
        }

        private void sniegWTle (PaintEventArgs e)
        {
            for (int i = 0; i < iloscPlatkowWTle; i++)
                g.FillEllipse(Brushes.White, sniegTlaX[i], sniegTlaY[i], 2, 2);
        }

        private void sniegFront (PaintEventArgs e)
        {
            for (int i = 0; i < iloscPlatkowFront; i++)
                g.FillEllipse(Brushes.White, sniegFrontX[i], sniegFrontY[i], 5, 5);
        }
    }
}
