﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace PictureViewer
{
    public partial class Form1 : Form
    {
        string sciezkaPliku = "";
        List<string> listaObrazkow = new List<string>();
        int index = 0;
        bool fullScreen = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {

        }

        private void otworzPlik(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = sciezkaPliku;
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    sciezkaPliku = openFileDialog1.FileName;
                    zbudujListeObrazkow();
                    index = listaObrazkow.IndexOf(sciezkaPliku);
                    pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;
                    pictureBox1.Image = Image.FromFile(listaObrazkow[index]);
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        public List<string> zbudujListeObrazkow()
        {
            var files = Directory.GetFiles(Path.GetDirectoryName(sciezkaPliku), "*.*", SearchOption.AllDirectories);
            foreach (string filename in files)
            {
                if (Path.GetExtension(filename) == ".jpg" ||
                    Path.GetExtension(filename) == ".JPG" ||
                    Path.GetExtension(filename) == ".gif" ||
                    Path.GetExtension(filename) == ".GIF" ||
                    Path.GetExtension(filename) == ".png" ||
                    Path.GetExtension(filename) == ".PNG")
                    listaObrazkow.Add(filename);
            }
            return listaObrazkow;
        }

        private void zapiszJako(object sender, EventArgs e)
        {
            try
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(sciezkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(sciezkaPliku);

                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    pictureBox1.Image.Save(saveFileDialog1.FileName);
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd zapisu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        private void wyjscieZProgramu(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void rotateRight90ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Image.RotateFlip(RotateFlipType.Rotate90FlipNone);
            pictureBox1.Refresh();
        }

        private void rotateLeft90ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Image.RotateFlip(RotateFlipType.Rotate90FlipXY);
            pictureBox1.Refresh();
        }

        private void obrazekWSzarosci(object sender, EventArgs e)
        {
            Bitmap kopia = new Bitmap(pictureBox1.Image);

            for (int i = 0; i < kopia.Width; i++)
            {
                progressBar1.Visible = true;
                progressBar1.Maximum = kopia.Width;
                progressBar1.Value = i;
                for (int j = 0; j < kopia.Height; j++)
                {
                    Color oc = kopia.GetPixel(i, j);
                    int grayScale = (int)((oc.R * 0.3) + (oc.G * 0.59) + (oc.B * 0.11));
                    Color newColor = Color.FromArgb(grayScale, grayScale, grayScale);
                    kopia.SetPixel(i, j, newColor);
                }
            }
            pictureBox1.Image = kopia;
            progressBar1.Visible = false;
        }

        private void convertToSepiaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Bitmap kopia = new Bitmap(pictureBox1.Image);

            for (int i = 0; i < kopia.Width; i++)
            {
                progressBar1.Visible = true;
                progressBar1.Maximum = kopia.Width;
                progressBar1.Value = i;
                for (int j = 0; j < kopia.Height; j++)
                {
                    Color oc = kopia.GetPixel(i, j);
                    int sepR = (int)((oc.R * 0.393) + (oc.G * 0.769) + (oc.B * 0.189));
                    int sepG = (int)((oc.R * 0.349) + (oc.G * 0.686) + (oc.B * 0.168));
                    int sepB = (int)((oc.R * 0.272) + (oc.G * 0.534) + (oc.B * 0.131));
                    if (sepR >= 255) sepR = 255;
                    if (sepG >= 255) sepG = 255;
                    if (sepB >= 255) sepB = 255;
                    Color newColor = Color.FromArgb(sepR, sepG, sepB);
                    kopia.SetPixel(i, j, newColor);
                }
            }
            pictureBox1.Image = kopia;
            progressBar1.Visible = false;
        }

        private void imageMirrorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Image.RotateFlip(RotateFlipType.RotateNoneFlipX);
            pictureBox1.Refresh();
        }

        private void stretchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
        }

        private void backChanges(object sender, EventArgs e)
        {
            pictureBox1.Image = Image.FromFile(sciezkaPliku);
            pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;
        }

        private void nextImage(object sender, EventArgs e)
        {
            if (index < listaObrazkow.Count - 1)
                index++;
            else if (index == listaObrazkow.Count - 1)
                index = 0;
            pictureBox1.Image = Image.FromFile(listaObrazkow[index]);
            sciezkaPliku = openFileDialog1.FileName;
        }

        private void previousImage(object sender, EventArgs e)
        {
            if (index > 0)
                index--;
            else if (index == 0)
                index = listaObrazkow.Count - 1;
            pictureBox1.Image = Image.FromFile(listaObrazkow[index]);
            sciezkaPliku = openFileDialog1.FileName;
        }

        private void goToFirstImage(object sender, EventArgs e)
        {
            if (index != 0)
            {
                index = 0;
                pictureBox1.Image = Image.FromFile(listaObrazkow[index]);
                sciezkaPliku = openFileDialog1.FileName;
            }
        }

        private void goToLastImage(object sender, EventArgs e)
        {
            if (index != listaObrazkow.Count - 1)
            {
                index = listaObrazkow.Count - 1;
                pictureBox1.Image = Image.FromFile(listaObrazkow[index]);
                sciezkaPliku = openFileDialog1.FileName;
            }
        }

        private void pictureBoxSlideShow_Click(object sender, EventArgs e)
        {
            if (fullScreen == true)
            {
                FormBorderStyle = FormBorderStyle.Fixed3D;
                WindowState = FormWindowState.Normal;
                fullScreen = false;
                timer1.Stop();
            }
            else if (fullScreen == false)
            {
                WindowState = FormWindowState.Maximized;
                WindowState = FormWindowState.Maximized;
                fullScreen = true;
                timer1.Start();
            }
            
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (index < listaObrazkow.Count - 1)
                index++;
            else if (index == listaObrazkow.Count - 1)
                index = 0;
            pictureBox1.Image = Image.FromFile(listaObrazkow[index]);
            sciezkaPliku = openFileDialog1.FileName;
        }
    }
}
