﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

// konkurs 1. try catch
// zapisywanie geometrii okna + sciezka do pliku
// private void
// rich text box
// kolorowanie slow kluczowych

// konkurs 2. przegladarka rysunkow .net

namespace Notatnik {

   public partial class Form1 : Form {

      #region fields/constructor

      [DllImport("user32.dll")]
      public static extern bool LockWindowUpdate(IntPtr hwndLock);

      private string filePath = "";
      private bool isTextChanged = false;
      private bool isRich = false;
      private int previousLength = 0;
      private string[] keyWords = new string[] { "public", "private",
         "namespace", "void", "using", "class", "string", "int", "bool",
         "byte", "if", "else", "region", "try", "catch", "finally" };

      public Form1() {
         InitializeComponent();
         UstawTytulOkna();
      }

      #endregion

      #region file operations

      private void OpenContents(string fName = "") {

         try {
            if (string.IsNullOrEmpty(fName)) {
               openFileDialog.FileName = fName;
               DialogResult dg = openFileDialog.ShowDialog();
               if (dg == DialogResult.OK) {
                  filePath = openFileDialog.FileName;
               }
            }
            else {
               filePath = fName;
            }
            string fileExt = Path.GetExtension(filePath);

            switch (fileExt) {
                  case ".txt":
                     txtEditor.Lines = File.ReadAllLines(filePath);
                     txtEditor.ReadOnly = openFileDialog.ReadOnlyChecked;
                     isRich = false;
                     break;
                  case ".rtf":
                  case ".cs":
                     txtRichEditor.LoadFile(filePath);
                     txtRichEditor.ReadOnly = openFileDialog.ReadOnlyChecked;
                     isRich = true;
                     ProcessKeyWords();
                     break;
               }
               PokazEdytor();
               isTextChanged = false;
               UstawTytulOkna();
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, "Blad odczytu pliku",
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
      }

      private bool SaveContents() {
         try {
            saveFileDialog.FileName = filePath;

            switch (isRich) {
               case false:
                  saveFileDialog.DefaultExt = "txt";
                  saveFileDialog.Filter = "Pliki tekstowe (*.txt)|*.txt";
                  break;
               case true:
                  saveFileDialog.DefaultExt = "rtf";
                  saveFileDialog.Filter = "Pliki rtf (*.rtf)|*.rtf|Pliki C# (*.cs)|*.cs";
                  break;
            }

            DialogResult dg = saveFileDialog.ShowDialog();
            if (dg == DialogResult.OK) {
               filePath = saveFileDialog.FileName;
               switch (isRich) {
                  case true:
                     txtRichEditor.SaveFile(filePath);
                     break;
                  case false:
                     File.WriteAllLines(filePath, txtEditor.Lines);
                     break;
               }
               isTextChanged = false;
               UstawTytulOkna();
               return true;
            }
            else if (dg == DialogResult.No) {
               WyczyscEdytor();
            }
            else if (dg == DialogResult.Cancel)
               return false;
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, "Blad zapisu pliku",
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         return false;
      }

      private bool Save() {
         try {
            if (File.Exists(filePath)) {
               switch (isRich) {
                  case true:
                     txtRichEditor.SaveFile(filePath);
                     break;
                  case false:
                     File.WriteAllLines(filePath, txtEditor.Lines);
                     break;
               }
               isTextChanged = false;
               UstawTytulOkna();
               return true;
            }
            else {
               bool exit = SaveContents();
               return exit;
            }
         }
         catch (Exception exc) {
            MessageBox.Show(exc.Message, "Blad zapisu pliku",
               MessageBoxButtons.OK, MessageBoxIcon.Error);
         }
         return false;
      }

      private bool SaveCurrent() {
         if (isTextChanged == true) {
            DialogResult dg = MessageBox.Show("Zapisac biezacy?", "Zapisywanie", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question);
            if (dg == DialogResult.Yes) {
               return Save();               
            }
            else if (dg == DialogResult.No) {
               WyczyscEdytor();
            }
            else if (dg == DialogResult.Cancel)
               return false;
         }
         return true;
      }

      #endregion

      #region menu formatowanie

      private void mnuWidokKolorTla_Click(object sender, EventArgs e) {
         DialogResult dg = colorDialog.ShowDialog();
         if (dg == DialogResult.OK) {
            switch (isRich) {
               case false:
                  txtEditor.BackColor = colorDialog.Color;
                  break;
               case true:
                  txtRichEditor.SelectionBackColor = colorDialog.Color;
                  break;
            }
         }
      }

      private void mnuWidokCzcionka_Click(object sender, EventArgs e) {
         DialogResult dg = fontDialog.ShowDialog();
         if (dg == DialogResult.OK) {
            switch (isRich) {
               case false:
                  txtEditor.Font = fontDialog.Font;
                  txtEditor.ForeColor = fontDialog.Color;
                  break;
               case true:
                  txtRichEditor.SelectionFont = fontDialog.Font;
                  txtRichEditor.SelectionColor = fontDialog.Color;
                  break;
            }
         }
      }

      private void mnuWidokZawijanieWierszy_Click(object sender, EventArgs e) {
         switch (isRich) {
            case false:
               txtEditor.WordWrap = mnuWidokZawijanieWierszy.Checked;
               break;
            case true:
               txtRichEditor.WordWrap = mnuWidokZawijanieWierszy.Checked;
               break;
         }
      }

      #endregion

      #region menu plik

      private void mnuPlikOtworz_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            OpenContents();
         }
      }

      private void mnuPlikZapiszJako_Click(object sender, EventArgs e) {
         SaveContents();
      }

      private void mnuPlikZakoncz_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true)
            this.Close();
      }

      private void mnuPlikZapisz_Click(object sender, EventArgs e) {
         Save();
      }

      private void mnuPlikNowy_Click(object sender, EventArgs e) {
         //SaveCurrent();
         //WyczyscEdytor();
      }

      private void mnuPlikNowyTxt_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            isRich = false;
            WyczyscEdytor();
            PokazEdytor();
         }
      }

      private void mnuPlikNowyRtf_Click(object sender, EventArgs e) {
         bool exit = SaveCurrent();
         if (exit == true) {
            isRich = true;
            WyczyscEdytor();
            PokazEdytor();
         }
      }

      #endregion

      #region edycja

      private void UstawTytulOkna() {
         string sciezkaPliku = "Nowy niezapisany plik";
         if (!(string.IsNullOrEmpty(filePath)))
            sciezkaPliku = Path.GetFileName(filePath);
         this.Text = sciezkaPliku + " - Notatnik .NET";
         if (isTextChanged)
            this.Text += " w trakcie edycji";
         if (isRich)
            this.Text += " w trybie RTF";

      }

      private void WyczyscEdytor() {
         filePath = "";
         txtEditor.Clear();
         txtRichEditor.Clear();
         isTextChanged = false;
         UstawTytulOkna();
      }

      private void PokazEdytor() {
         if (isRich) {
            txtEditor.Visible = false;
            txtRichEditor.Visible = true;
         }
         else {
            txtEditor.Visible = true;
            txtRichEditor.Visible = false;
         }
      }
      
      
      #endregion

      #region highlight

      private void ProcessLineKeyWords(int lineNumber) {
         if (txtRichEditor.Text == string.Empty)
            return;

         int lineLength = txtRichEditor.Lines[lineNumber].Length;
         if (lineLength == 0)
            return;

         this.txtRichEditor.TextChanged -= this.txtRichEditor_TextChanged;
         LockWindowUpdate(txtRichEditor.Handle);
         txtRichEditor.WordWrap = false;

         int selectionStart = txtRichEditor.SelectionStart;
         int column = selectionStart - txtRichEditor.GetFirstCharIndexOfCurrentLine();
         string[] lineWords = txtRichEditor.Lines[lineNumber].Split(' ');
         int lineStart = selectionStart - column;
         int wordSelect = lineStart;

         foreach (string lineWord in lineWords) {
            foreach (string keyWord in keyWords) {
               txtRichEditor.SelectionStart = wordSelect;
               txtRichEditor.SelectionLength = lineWord.Length;

               if (lineWord == keyWord) {
                  txtRichEditor.SelectionColor = Color.Blue;
                  txtRichEditor.SelectionStart = lineStart + column;
                  txtRichEditor.SelectionLength = 0;
                  break;
               }
               else {
                  txtRichEditor.SelectionColor = Color.Black;
                  txtRichEditor.SelectionStart = lineStart + column;
                  txtRichEditor.SelectionLength = 0;
               }
            }
            wordSelect += lineWord.Length;
            wordSelect += 1;
         }
         LockWindowUpdate(IntPtr.Zero);
         this.txtRichEditor.TextChanged += this.txtRichEditor_TextChanged;
      }

      [Obsolete]
      private void ProcessKeyWords_() {
         if (txtRichEditor.Text == string.Empty)
            return;

         MessageBox.Show(txtRichEditor.Lines.Length.ToString());

         txtRichEditor.WordWrap = false;
         for (int i = 0; i < txtRichEditor.Lines.Length; i++)
            ProcessLineKeyWords(i);
      }

      private void ProcessKeyWords() {

         if (txtRichEditor.Text == string.Empty)
            return;

         this.txtRichEditor.TextChanged -= this.txtRichEditor_TextChanged;

         LockWindowUpdate(txtRichEditor.Handle);
         txtRichEditor.WordWrap = false;

         int selectionStart = txtRichEditor.SelectionStart;
         string content = txtRichEditor.Text;

         string[] contents = content.Split(new string[] { "\n" }, StringSplitOptions.None);
         int currentPosition = 0;

         foreach (string contentLine in contents) {

            string[] words = contentLine.Split(' ');

            foreach (string word in words) {
               currentPosition += word.Length;
               foreach (string keyword in keyWords) {
                  if (word == keyword) {
                     txtRichEditor.Select(currentPosition - word.Length, word.Length);
                     txtRichEditor.SelectionColor = Color.Blue;
                     break;
                  }
                  else {
                     txtRichEditor.Select(currentPosition - word.Length, word.Length);
                     txtRichEditor.SelectionColor = Color.Black;
                  }
               }
               currentPosition += 1;
            }
         }
         txtRichEditor.Select(selectionStart, 0);
         LockWindowUpdate(IntPtr.Zero);
         this.txtRichEditor.TextChanged += this.txtRichEditor_TextChanged;
      }

      #endregion

      #region form events

      private void txtEditor_TextChanged(object sender, EventArgs e) {
         isTextChanged = true;
         UstawTytulOkna();
      }

      private void txtRichEditor_TextChanged(object sender, EventArgs e) {

         isTextChanged = true;
         UstawTytulOkna();
         int currentLength = txtRichEditor.TextLength;
         int currentLine = txtRichEditor.GetLineFromCharIndex(txtRichEditor.SelectionStart);

         if (currentLength > (previousLength + 1))
            ProcessKeyWords();
         else
            ProcessLineKeyWords(currentLine);

         previousLength = currentLength;
      }

      private void Form1_FormClosing(object sender, FormClosingEventArgs e) {
         bool exit = SaveCurrent();
         if (exit == false)
            e.Cancel = true;
      }

      private void Form1_FormClosed(object sender, FormClosedEventArgs e) {
         Properties.Settings.Default.FilePath = filePath;
         Properties.Settings.Default.Left = this.Left;
         Properties.Settings.Default.Top = this.Top;
         Properties.Settings.Default.Width = this.Width;
         Properties.Settings.Default.Height = this.Height;
         Properties.Settings.Default.Save();
      }

      private void Form1_Load(object sender, EventArgs e) {
         
         this.Left = Properties.Settings.Default.Left;
         this.Top = Properties.Settings.Default.Top;
         this.Width = Properties.Settings.Default.Width;
         this.Height = Properties.Settings.Default.Height;
         
         string fileFromProperties = Properties.Settings.Default.FilePath;
         if (File.Exists(fileFromProperties)) {
            filePath = fileFromProperties;
            OpenContents(filePath);
         }
      }

      #endregion
            
   }
}
