﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using System.Text.RegularExpressions;

namespace Notatnik_DH
{
    public partial class Form1 : Form
    {
        string SciezkaPliku = "";
        bool TekstZmieniony = false;
        Properties.Settings ustawieniaDomyslne = Properties.Settings.Default;

        public Form1()
        {
            InitializeComponent();
        }

        private void otworzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = Path.GetFileName(SciezkaPliku);

                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    
                    if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
                    {
                        richTextBox1.LoadFile(openFileDialog1.FileName, RichTextBoxStreamType.RichText);    
                    }
                    else
                    {
                        richTextBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                    }
                    
                    SciezkaPliku = openFileDialog1.FileName;
                    TekstZmieniony = false;
                    UstalTytulOkna();
                }

            }
            catch (Exception exc)
            {

                MessageBox.Show(
                    "Blad odczytu pliku !" + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }

        }

        private void UstalTytulOkna()
        {
            this.Text = Path.GetFileName(SciezkaPliku) + (TekstZmieniony ? "*" : "") + " - Notatnik_DH";
        }

        private void Nowy_toolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = "";
            SciezkaPliku = "";
            //TekstZmieniony = false;
            UstalTytulOkna();
        }

        private void ZapiszJako_toolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszDoPlikuJako();
        }

        private bool zapiszDoPlikuJako()
        {
            try {
                if (File.Exists(SciezkaPliku))
                {
                    saveFileDialog1.InitialDirectory = Path.GetDirectoryName(SciezkaPliku);
                    saveFileDialog1.FileName = Path.GetFileName(SciezkaPliku);
                }
                else
                {
                    saveFileDialog1.FileName = "";
                }

                //------------------------------------------------------------------------------------------
                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    richTextBox1.ReadOnly = false;
                    File.WriteAllLines(saveFileDialog1.FileName, richTextBox1.Lines);
                    SciezkaPliku = saveFileDialog1.FileName;
                    TekstZmieniony = false;
                    UstalTytulOkna();
                    return true;
                }
                else return false;
            }
            catch(Exception exc)
            {

                MessageBox.Show(
                    "Blad zapisu "+exc.Message,
                       this.Text,
                       MessageBoxButtons.OK,
                       MessageBoxIcon.Error);
                return false;
            }
        }

        private void Zapisz_toolStripMenuItem_Click(object sender, EventArgs e)
        {
              zapiszDoPliku();
        }

        private bool zapiszDoPliku()
        {
            try
            {
                if (!File.Exists(SciezkaPliku)) return zapiszDoPlikuJako();
                else
                {
                    File.WriteAllLines(SciezkaPliku, richTextBox1.Lines);
                    TekstZmieniony = false;
                    UstalTytulOkna();
                    return true;
                }

            }

            catch (Exception exc)
            {
                MessageBox.Show(
                    "Blad zapisu pliku " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);

                return false;
            }
 
        }

        private void zakoncz_ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!TekstZmieniony) Close();
            else if (spytajCzyZapisac()) Close();
        }

        private bool spytajCzyZapisac()
        {
            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisac zmiany w pliku: "+SciezkaPliku+" ?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question
                );
            switch (dr)
            {
               case DialogResult.Yes:
                    return zapiszDoPliku();
               case DialogResult.No:
                    return true;
               case DialogResult.Cancel:
                    return false;
                default:
                    throw new Exception("Nieprzewidziana wartosc zmiennej 'dr'");
            }
        }



        private void Sprawdz_zawijanieWierszyToolStripMenuItem(object sender, EventArgs e)
        {
            richTextBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
            {
                fontDialog1.Font = richTextBox1.SelectionFont;
                fontDialog1.Color = richTextBox1.SelectionColor;
            }
            else
            {
                fontDialog1.Font = richTextBox1.Font;
                fontDialog1.Color = richTextBox1.ForeColor;
            }

            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {

                if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
                {
                    richTextBox1.SelectionFont = fontDialog1.Font;
                    richTextBox1.SelectionColor = fontDialog1.Color;
                }
                else
                {
                    richTextBox1.Font = fontDialog1.Font;
                    richTextBox1.ForeColor = fontDialog1.Color;
                }
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color= richTextBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                richTextBox1.BackColor = colorDialog1.Color;
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            ustawieniaDomyslne.FormLeft = this.Left;
            ustawieniaDomyslne.FormTop = this.Top;
            ustawieniaDomyslne.FormWidth = this.Width;
            ustawieniaDomyslne.FormHeight = this.Height;
            ustawieniaDomyslne.sciezkaPliku = this.SciezkaPliku;
            ustawieniaDomyslne.Save();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Left = ustawieniaDomyslne.FormLeft;
            Top = ustawieniaDomyslne.FormTop;
            Width = ustawieniaDomyslne.FormWidth;
            Height = ustawieniaDomyslne.FormHeight;
            this.SciezkaPliku=ustawieniaDomyslne.sciezkaPliku;

            if (File.Exists(ustawieniaDomyslne.sciezkaPliku))
            {
                SciezkaPliku = ustawieniaDomyslne.sciezkaPliku;
            }

        }

        private void richTextBox1_TextChanged_1(object sender, EventArgs e)
        {
            TekstZmieniony = true;
            UstalTytulOkna();
            CsharpKeyWord();
            
        }
        //lista slow kluczowych dla drugiego rozwiazania
        public Regex listaSlow = new Regex("if |then |else |true |false |while |do |done |set |export |bool |break |case |class |const |for |foreach |goto |in |void |enum |private |if\n|then\n|else\n|fi\n|true\n|false\n|while\n|do\n|done\n|set\n|export\n|bool\n|break\n|case\n|class\n|const\n|for\n|foreach\n|goto\n|in\n|void\n|enum\n|private\n");
        private void CsharpKeyWord()
        {
            ////-----------------------------------------------------------------------------------------------
            ////---------------------------------------drugie-lepsze rozwiazanie-------------------------------
            ////-----------------------------------------------------------------------------------------------
            //dla drugiego rozwiazania
            //dodac liste public slow kluczowych
            //oraz dodac biblioteke??? "using System.Text.RegularExpressions;"

            //wybierz wszystko i ustaw czcionke black-niekonieczne
            richTextBox1.SelectAll();
            richTextBox1.SelectionColor = Color.Black;

            // przechodzi  na koniec pliku
            richTextBox1.ScrollToCaret();
            richTextBox1.Select(richTextBox1.Text.Length, 1);

            // zapisuje aktualna pozycje karetki
            int selPos = richTextBox1.SelectionStart;

            //dla kazdego slowa zawartego w listaSlow w richTextBox (znajdz/dopasuj dane slwo w richTextBox)
            foreach (Match keyWordMatch in listaSlow.Matches(richTextBox1.Text))
            {
                // zaznacz znalezione slowo (poczatek slowa i dlugosc slowa)
                richTextBox1.Select(keyWordMatch.Index, keyWordMatch.Length);
                // zmien kolor slow na niebieski
                richTextBox1.SelectionColor = Color.Blue;
                // Mozna pogrubic czcionke...
                richTextBox1.SelectionFont = new Font(richTextBox1.SelectionFont, FontStyle.Bold);
                // przejddz karetka do pozycji wyjsciowej/poczatkowej
                richTextBox1.SelectionStart = selPos;
                // zmien kolor czcionki spowrotem na czarny i bez pogrubienia
                richTextBox1.SelectionColor = Color.Black;
                richTextBox1.SelectionFont = new Font(richTextBox1.SelectionFont, FontStyle.Regular);
            }

            //-----------------------------------------------------------------------------------------------
            //--------------------------------------------pierwsze rozwiazanie-------------------------------
            //-----------------------------------------------------------------------------------------------
            ////lista slow kluczowych
            //string[] listaSlow = { "if","then","else", "true" ,"false" ,"while", "do" ,"done" ,"set","export" ,"bool" ,"break" ,"case" ,"class" ,"const", "for" ,"foreach", "goto","in" ,"void" ,"enum","private"  };
            ////zapisz poczatkowa pozycje karetki
            //int StartCursorPosition = richTextBox1.SelectionStart;
            ////dla kazdego elementu tablicy listaSlow 
            //foreach (var item in listaSlow)
            //{
            //    //przeszukuje czaly tekst
            //    int i = 0;
            //    for (; i < richTextBox1.Text.LastIndexOf(item); i++)
            //    {
            //        //znajdz slowo z listySlow
            //        richTextBox1.Find(item, i, RichTextBoxFinds.WholeWord);
            //        //zaznacz na czerwono i czcionka pogrubiona
            //        richTextBox1.SelectionColor = Color.Red;
            //        richTextBox1.SelectionFont = new Font(richTextBox1.SelectionFont, FontStyle.Bold);
            //        //idz do pozycji ostatniej kursora
            //        richTextBox1.SelectionStart = StartCursorPosition;
            //        //wroc do czarnej czcionki i bez pogrubienia
            //        richTextBox1.SelectionColor = Color.Black;
            //        richTextBox1.SelectionFont = new Font(richTextBox1.SelectionFont, FontStyle.Regular);
            //    }
            //}




        }

    }
}
