﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Numerics;

namespace WindowsFormsApplication1 {
   public partial class Form1 : Form {
      public Form1() {
         InitializeComponent();
      }

      private void tColorR_Scroll(object sender, EventArgs e) {
         ApplyChange();
      }

      private void tColorG_Scroll(object sender, EventArgs e) {
         ApplyChange();
      }

      private void tColorB_Scroll(object sender, EventArgs e) {
         ApplyChange();
      }

      private void ApplyChange() {
         SetLabels();
         SetHex();
         SetWindowText();
         FillPanel();

         

      }

      private void SetLabels() {
         labelR.ForeColor = Color.FromArgb(tColorR.Value, 0, 0);
         labelR.Text = tColorR.Value.ToString("X2");
         labelG.ForeColor = Color.FromArgb(0, tColorG.Value, 0);
         labelG.Text = tColorG.Value.ToString("X2");
         labelB.ForeColor = Color.FromArgb(0, 0, tColorB.Value);
         labelB.Text = tColorB.Value.ToString("X2");
      }

      private void SetHex() {
         string hex;
         hex = "#" + labelR.Text + labelG.Text + labelB.Text;
         labelH.Text = hex;
         Clipboard.SetText(hex);
      }

      private void SetWindowText() {
         this.Text = "Red:" + tColorR.Value
            + " Green: " + tColorG.Value
            + " Blue: " + tColorB.Value + " ";
      }

      private void FillPanel() {
         Panel.BackColor = Color.FromArgb(tColorR.Value, tColorG.Value, tColorB.Value);
      }

      private void Form1_FormClosed(object sender, FormClosedEventArgs e) {
         
         Properties.Settings.Default.R = (byte)tColorR.Value;
         Properties.Settings.Default.G = (byte)tColorG.Value;
         Properties.Settings.Default.B = (byte)tColorB.Value;
         Properties.Settings.Default.Left = this.Left;
         Properties.Settings.Default.Top = this.Top;
         Properties.Settings.Default.Width = this.Width;
         Properties.Settings.Default.Height = this.Height;

         Properties.Settings.Default.Save();

         for (; Opacity>0; Opacity-=0.01) {
            System.Threading.Thread.Sleep(1);
         }
      }

      private void Form1_FormClosing(object sender, FormClosingEventArgs e) {

         bool changedValues = false;
         if (Properties.Settings.Default.R != (byte)tColorR.Value
            || Properties.Settings.Default.G != (byte)tColorG.Value
            || Properties.Settings.Default.B != (byte)tColorB.Value)
         {
            changedValues = true;
         }

         if (changedValues) {
            DialogResult dr = MessageBox.Show("Zamknac?", this.Text, MessageBoxButtons.YesNo);
            if (dr == System.Windows.Forms.DialogResult.No) {
               e.Cancel = true;
            }
         }
      }

      private void button1_Click(object sender, EventArgs e) {
         tColorR.Value = 0;
         tColorG.Value = 0;
         tColorB.Value = 0;
         ApplyChange();
      }

      private void button2_Click(object sender, EventArgs e) {
         this.Close();
      }

      private void Form1_Load(object sender, EventArgs e) {
         tColorR.Value = Properties.Settings.Default.R;
         tColorG.Value = Properties.Settings.Default.G;
         tColorB.Value = Properties.Settings.Default.B;

         this.Left = Properties.Settings.Default.Left;
         this.Top = Properties.Settings.Default.Top;
         this.Width = Properties.Settings.Default.Width;
         this.Height = Properties.Settings.Default.Height;
         
         foreach (string colorName in Enum.GetNames(typeof(KnownColor))) {
            cbColor.Items.Add(colorName);
         }
         ApplyChange();
      }

      private void cbColor_SelectedValueChanged(object sender, EventArgs e) {
         Color selectedColor = Color.FromName(cbColor.SelectedItem.ToString());
         int red = selectedColor.R;
         int green = selectedColor.G;
         int blue = selectedColor.B;
         tColorR.Value = red;
         tColorG.Value = green;
         tColorB.Value = blue;
         ApplyChange();
      }
   }
}
