﻿using System;
using System.Drawing;
using System.Windows.Forms;
// https://www.fizyka.umk.pl/~jacek/

// Zadanie Domowe : Zrobić coś aby ta aplikacja była czymś fajnym i użytkowym!

namespace Kolory
{
    public partial class Form1 : Form
    {
        Properties.Settings s = Properties.Settings.Default;
        public int[] colors = new int[4];
        double timer = 0;
        

        public Form1()
        {
            InitializeComponent();
        }

        private void ZmienKolor(object sender, EventArgs e)
        {
            panel1.BackColor = Color.FromArgb(trackBarR.Value,
                                              trackBarG.Value,
                                              trackBarB.Value
                                             );
            labelR.Text = trackBarR.Value.ToString();
            labelG.Text = trackBarG.Value.ToString();
            labelB.Text = trackBarB.Value.ToString();

            CheckColor();

        }

        private void CheckColor()
        {
            int cR, cG, cB;
            int tR, tG, tB;
            int[] difficult = new int[4] {1, 5, 10, 15 }; // poziomy trudności wielkość +- wartości kolorów.
            int choseDifficult = 5;

            if (comboBox1.SelectedIndex > -1)
                choseDifficult = difficult[comboBox1.SelectedIndex];

            cR = colors[0];
            cG = colors[1];
            cB = colors[2];

            tR = trackBarR.Value;
            tG = trackBarG.Value;
            tB = trackBarB.Value;

            if (colors[3] == 1)
            {

                if ((tR >= cR - choseDifficult && tR <= cR + choseDifficult) 
                    && (tG >= cG - choseDifficult && tG <= cG + choseDifficult) 
                    && (tB >= cB - choseDifficult && tB <= cB + choseDifficult)
                    )
                {
                    labelOk.Text = "DOBRZE";
                    timer1.Enabled = false;
                    trackBarR.Enabled = false;
                    trackBarG.Enabled = false;
                    trackBarB.Enabled = false;

                    DialogResult dr = MessageBox.Show("Dobrze.\nTwój czas to: " + labelTime.Text);

                    s.Wyniki.Add(labelTime.Text);
                    GetResults();
                }

            }

        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {

            s.R = (byte)trackBarR.Value;
            s.G = (byte)trackBarG.Value;
            s.B = (byte)trackBarB.Value;
            s.Difficult = comboBox1.SelectedIndex;

            s.Save(); // Zapisywanie zmian do ustawien w settings!

        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {

            if (trackBarR.Value != s.R ||
                trackBarG.Value != s.G ||
                trackBarB.Value != s.B ||
                comboBox1.SelectedIndex != s.Difficult
                )
            {
                DialogResult dr = MessageBox.Show("Czy na pewno chcesz zamknąć program?",
                                this.Text,
                                MessageBoxButtons.YesNo,
                                MessageBoxIcon.Question
                                );
                if (dr == DialogResult.No) e.Cancel = true;
            }

        }

        private void button1_Click(object sender, EventArgs e)
        {
            ResetColor();
            timer1.Enabled = false;
        }

        private void ResetColor()
        {
            trackBarR.Value = 0;
            trackBarG.Value = 0;
            trackBarB.Value = 0;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //Zczytywanie z settingsów.
            /*trackBarR.Value = s.R;
            trackBarG.Value = s.G;
            trackBarB.Value = s.B;
            */
            trackBarR.Enabled = false;
            trackBarG.Enabled = false;
            trackBarB.Enabled = false;

            comboBox1.SelectedIndex = s.Difficult;

            GetResults();

        }

        private void GetResults()
        {
            // Wczytanie ostatnich wyników.
            richTextBox1.Text = "Lista Twoich ostatnich wyników: \n";
            for (int l = s.Wyniki.Count - 1; /*l > s.Wyniki.Count - 11 &&*/ l >= 0; l--)
            {
                if (l != s.Wyniki.Count - 1)
                    richTextBox1.Text += "\n";
                richTextBox1.Text += s.Wyniki[l];
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {

            trackBarR.Enabled = true;
            trackBarG.Enabled = true;
            trackBarB.Enabled = true;

            colors = RandomColor();
            panel2.BackColor = Color.FromArgb(colors[0],colors[1],colors[2]);
            ResetColor();
            colors[3] = 1;
            labelOk.Text = "Dopasuj kolory:";
            labelRC.Text = "Podpowiedź: " + colors[0] + "." + colors[1] + "." + colors[2];
            timer = 0.0;
            timer1.Enabled = true;
        }

        private int[] RandomColor()
        {
            Random r = new Random();
            int[] ranColors = new int[4];
            ranColors[0] = r.Next(255) + 1;
            ranColors[1] = r.Next(255) + 1;
            ranColors[2] = r.Next(255) + 1;

            return ranColors;
        }

        private string KolorHex()
        {
            string hex = "#";
            hex += trackBarR.Value.ToString("X2"); // konwersja na liczbę typu HEX 
            hex += trackBarG.Value.ToString("X2");
            hex += trackBarB.Value.ToString("X2");
            return hex;
        }

        
        private void timer1_Tick(object sender, EventArgs e)
        {
            timer++;
            var t = TimeSpan.FromSeconds(timer);
            labelTime.Text = t.ToString();
            ;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedIndex == 3)
                labelRC.Visible = true;
            else
                labelRC.Visible = false;

        }
    }
}
