﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace ZadaniaWPF
{
    using ModelWidoku;
    using System.Windows.Input;

    public abstract class DialogBox : FrameworkElement, INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        protected Action<Object> execute = null;

        public string Caption { get; set; }

        protected ICommand show;

        public virtual ICommand Show
        {
            get
            {
                if (show == null) show = new RelayCommand(execute);
                return show;
            }
        }
    }

    public class SimpleMessageDialogBox : DialogBox
    {
        public SimpleMessageDialogBox()
        {
            execute =
                o =>
                {
                    MessageBox.Show((string)o, Caption);
                };
        }
    }

    public abstract class CommandDialogBox : DialogBox
    {
        public override ICommand Show
        {
            get
            {
                if (show == null) show = new RelayCommand(
                    o=>
                    {
                        ExecuteCommand(CommandBefore, CommandParameter);
                        //if(CommandBefore.CanExecute)
                        execute(o);
                        ExecuteCommand(CommandAfter, CommandParameter);
                    });
                return show;
            }
        }

        public static DependencyProperty CommandParameterProperty =
            DependencyProperty.Register("CommandParameter", typeof(object), typeof(CommandDialogBox));

        public object CommandParameter
        {
            get
            {
                return GetValue(CommandParameterProperty);
            }
            set
            {
                SetValue(CommandParameterProperty, value);
            }
        }

        protected static void ExecuteCommand(ICommand command, object commandParameter)
        {
            if (command != null)
                if (command.CanExecute(commandParameter))
                    command.Execute(commandParameter);
        }

        public static DependencyProperty CommandBeforeProperty =
            DependencyProperty.Register("CommandBefore", typeof(ICommand), typeof(CommandDialogBox));

        public ICommand CommandBefore
        {
            get
            {
                return (ICommand)GetValue(CommandBeforeProperty);
            }
            set
            {
                SetValue(CommandBeforeProperty, value);
            }
        }

        public static DependencyProperty CommandAfterProperty =
            DependencyProperty.Register("CommandAfter", typeof(ICommand), typeof(CommandDialogBox));

        public ICommand CommandAfter
        {
            get
            {
                return (ICommand)GetValue(CommandAfterProperty);
            }
            set
            {
                SetValue(CommandAfterProperty, value);
            }
        }
    }

    public class NotificationDialogBox : CommandDialogBox
    {
        public NotificationDialogBox()
        {
            execute =
                o =>
                {
                    MessageBox.Show((string)o, Caption, MessageBoxButton.OK, MessageBoxImage.Information);
                };
        }
    }

    public class MessageDialogBox : CommandDialogBox
    {
        public MessageBoxResult? LastResult { get; protected set; }
        public MessageBoxButton Buttons { get; set; }
        public MessageBoxImage Icon { get; set; }

        public MessageDialogBox()
        {
            Buttons = MessageBoxButton.OK;
            Icon = MessageBoxImage.None;

            execute =
                o =>
                {
                    LastResult = MessageBox.Show((string)o, Caption, Buttons, Icon);
                    OnPropertyChanged("LastResult");

                    switch (LastResult)
                    {
                        case MessageBoxResult.Yes:
                            ExecuteCommand(CommandYes, CommandParameter);
                            break;
                        case MessageBoxResult.No:
                            ExecuteCommand(CommandNo, CommandParameter);
                            break;
                    }
                };
        }

        public static DependencyProperty CommandYesProperty =
            DependencyProperty.Register("CommandYes", typeof(ICommand), typeof(CommandDialogBox));

        public ICommand CommandYes
        {
            get
            {
                return (ICommand)GetValue(CommandYesProperty);
            }
            set
            {
                SetValue(CommandYesProperty, value);
            }
        }

        public static DependencyProperty CommandNoProperty =
            DependencyProperty.Register("CommandNo", typeof(ICommand), typeof(CommandDialogBox));

        public ICommand CommandNo
        {
            get
            {
                return (ICommand)GetValue(CommandNoProperty);
            }
            set
            {
                SetValue(CommandNoProperty, value);
            }
        }
    }
}
