﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows;
using System.Windows.Input;
using System.Windows.Interactivity;
using System.Windows.Controls;

namespace AsystentSklepowyWPF
{
    #region Blend Behaviors
    public class ZamknięcieOknaPoNaciśnięciuKlawisza : Behavior<Window>
    {
        public Key Klawisz { get; set; }

        protected override void OnAttached()
        {
            Window window = (Window)this.AssociatedObject;
            if (window != null) window.PreviewKeyDown += window_PreviewKeyDown;
        }

        void window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Klawisz) (sender as Window).Close();
        }
    }

    public class PrzyciskZamykającyOkno : Behavior<Window>
    {
        public static readonly DependencyProperty PrzyciskProperty =
            DependencyProperty.Register(
                "Przycisk",
                typeof(Button),
                typeof(PrzyciskZamykającyOkno),
                new PropertyMetadata(null, PrzyciskZmieniony));

        public Button Przycisk
        {
            get { return (Button)GetValue(PrzyciskProperty); }
            set { SetValue(PrzyciskProperty, value); }
        }

        private static void PrzyciskZmieniony(
            DependencyObject d, 
            DependencyPropertyChangedEventArgs e)
        {
            Window window = ((PrzyciskZamykającyOkno)d).AssociatedObject as Window;
            RoutedEventHandler button_Click =
                (object sender, RoutedEventArgs _e) =>
                {
                    window.Close();
                };
            if (e.OldValue != null) (e.OldValue as Button).Click -= button_Click;
            if (e.NewValue != null) (e.NewValue as Button).Click += button_Click;
        }
    }

    public class PrzyciskZamykającyOkno2 : Behavior<Window>
    {
        public static readonly DependencyProperty PrzyciskProperty =
            DependencyProperty.Register(
                "Przycisk",
                typeof(Button),
                typeof(PrzyciskZamykającyOkno2),
                new PropertyMetadata(null, PrzyciskZmieniony));

        public Button Przycisk
        {
            get { return (Button)GetValue(PrzyciskProperty); }
            set { SetValue(PrzyciskProperty, value); }
        }

        public static readonly DependencyProperty PolecenieProperty =
            DependencyProperty.Register(
                "Polecenie",
                typeof(ICommand),
                typeof(PrzyciskZamykającyOkno2));

        public ICommand Polecenie
        {
            get { return (ICommand)GetValue(PolecenieProperty); }
            set { SetValue(PolecenieProperty, value); }
        }

        public static readonly DependencyProperty ParametrPoleceniaProperty =
            DependencyProperty.Register(
                "ParametrPolecenia",
                typeof(object),
                typeof(PrzyciskZamykającyOkno2));

        public object ParametrPolecenia
        {
            get { return GetValue(ParametrPoleceniaProperty); }
            set { SetValue(ParametrPoleceniaProperty, value); }
        }

        private static void PrzyciskZmieniony(
            DependencyObject d,
            DependencyPropertyChangedEventArgs e)
        {
            Window window = ((PrzyciskZamykającyOkno2)d).AssociatedObject as Window;
            RoutedEventHandler button_Click =
                (object sender, RoutedEventArgs _e) =>
                {
                    ICommand polecenie = (d as PrzyciskZamykającyOkno2).Polecenie;
                    object parametrPolecenia = (d as PrzyciskZamykającyOkno2).ParametrPolecenia;
                    if (polecenie != null) polecenie.Execute(parametrPolecenia);
                    window.Close();
                };
            if (e.OldValue != null) (e.OldValue as Button).Click -= button_Click;
            if (e.NewValue != null) (e.NewValue as Button).Click += button_Click;
        }
    }
    #endregion

#region Attached Behaviors
    public static class KlawiszWyłączBehavior
    {
        public static Key GetKlawisz(DependencyObject d)
        {
            return (Key)d.GetValue(KlawiszProperty);
        }

        public static void SetKlawisz(DependencyObject d, Key value)
        {
            d.SetValue(KlawiszProperty, value);
        }

        public static readonly DependencyProperty KlawiszProperty =
            DependencyProperty.RegisterAttached(
                "Klawisz",
                typeof(Key),
                typeof(KlawiszWyłączBehavior),
                new PropertyMetadata(Key.None, KlawiszZmieniony));

        private static void KlawiszZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Key klawisz = (Key)e.NewValue;
            if(d is Window)
            {
                (d as Window).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz) (sender as Window).Close();
                    };
            }
            else
            {
                (d as UIElement).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz) (sender as UIElement).IsEnabled = false;
                    };
            }
        }
    }

#endregion
}
