﻿using System;

namespace AsystentSklepowyWPF.Model
{
    public class AutoSumowanie
    {
        private decimal limit;
        private decimal suma = 0;

        public AutoSumowanie(decimal limit)
        {
            this.limit = limit;
        }

        public void Dodaj(decimal kwota)
        {
            if (!CzyKwotaPoprawna(kwota)) 
                throw new ArgumentOutOfRangeException("Kwota zbyt duża lub ujemna");
            suma += kwota;
        }

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }

        private bool czyPrzekroczyLimit(decimal kwota)
        {
            return suma + kwota > limit;
        }

        public bool CzyKwotaPoprawna(decimal kwota)
        {
            return kwota > 0 && !czyPrzekroczyLimit(kwota);
        }
    }
}
