﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AsystentSklepowyWPF.Model;
using System.Windows.Input;
using System.Windows;
using System.ComponentModel;

namespace AsystentSklepowyWPF.ModelWidoku
{
    public class ModelWidoku : INotifyPropertyChanged
    {
        AutoSumowanie model = new AutoSumowanie(1000);

        private decimal kwota;
        public string Suma
        {
            get 
            { 
                return Convert.ToString(model.Suma); 
            }
        }

        public string Kwota
        {
            get
            {
                return kwota.ToString();
            }
            set
            {
                try
                {
                    kwota = decimal.Parse(value);
                }
                catch
                {
                    kwota = 0; MessageBox.Show("Popraw Kwotę");
                }
            }
        }

        public ICommand DodajKwoteCommand
        {
            get
            {
                return new RelayCommand(
                    (object argument) =>
                    {
                        try
                        {
                            model.Dodaj(kwota);
                            kwota = 0;
                            OnpropertyChanged("Suma");
                            OnpropertyChanged("Kwota");
                        }
                        catch (ArgumentException)
                        {
                            MessageBox.Show("Za duża kwota");
                        }
                    });
            }
        }

        public bool CzyKwotaPrzekroczyLimit(decimal kwota)
        {
            return model.CzyPrzekroczyLimit(kwota);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnpropertyChanged(string nazwaWłasnosci)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasnosci));

        }
    }
}
