﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AsystentSklepowyWPF.Model;
using System.Windows.Input;
using System.Windows;
using System.ComponentModel;

namespace AsystentSklepowyWPF.ModelWidoku
{
    public class ModelWidoku : INotifyPropertyChanged
    {
        AutoSumowanie autosumM = new AutoSumowanie(1000);

        //instancja klasy

        private decimal kwota;
        public string Suma
        {
            get 
            { 
                return Convert.ToString(autosumM.Suma); 
            }
        }

        public string Kwota
        {
            get
            {
                return kwota.ToString();
            }
            set
            {
                try
                {
                    kwota = decimal.Parse(value);
                }
                catch
                {
                    kwota = 0; MessageBox.Show("Popraw Kwotę");

                }
            }
        }

        public ICommand DodajKwoteCommand
        {
            get
            {
                return new RelayCommand(
                    (object argument) =>
                    {
                        try
                        {
                            autosumM.Dodaj(kwota);
                            OnpropertyChanged("Suma");
                            kwota = 0;
                            OnpropertyChanged("Kwota");
                        }

                        catch (ArgumentException)
                        {
                            MessageBox.Show("Za duża kwota");
                        }
                    });
            }
        }

        public bool CzyKwotaPrzekroczyLimit(decimal kwota)
        {
            return autosumM.CzyPrzekroczyLimit(kwota);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnpropertyChanged(string nazwaWłasnosci)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasnosci));

        }
    }
}
