﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Data;
using KoloryWPF.ViewModel;
using System.Windows.Media;

namespace KoloryWPF
{
    public static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            return Color.FromRgb(kolor.R, kolor.G, kolor.B);
        }
    }

    public class KolorToSolidColorBrushConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            Kolor kolor = (Kolor)value;
            return new SolidColorBrush(kolor.ToColor());
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class KolorToColorConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            Kolor kolor = (Kolor)value;
            return kolor.ToColor();
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            //throw new NotImplementedException();
            Color kolor = (Color)value;
            return new Kolor(kolor.R, kolor.G, kolor.B);
        }
    }

    public class SkładoweKoloruToColorConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            byte r = (byte)(double)values[0];
            byte g = (byte)(double)values[1];
            byte b = (byte)(double)values[2];
            return Color.FromRgb(r, g, b);
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
