﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Thread = System.Threading.Thread;

namespace ProgramowanieAsynchroniczne
{
    class Program
    {
        static double obliczenia(double argument)
        {
            for(int i = 0; i<10; ++i)
            {
                argument = Math.Asin(Math.Sin(argument));
            }
            return argument;
        }

        static void MainParallelFor(string[] args)
        {
            //przygotowania
            int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar]; 
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.NextDouble();

            //obliczenia sekwencyjne
            int liczbaPowtórzeń = 10000;
            double[] wyniki = new double[rozmiar];
            int start = System.Environment.TickCount;
            for(int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; powtórzenia++)
            {
                for (int i = 0; i < rozmiar; ++i) wyniki[i] = obliczenia(tablica[i]);
            }
            int stop = System.Environment.TickCount;
            Console.WriteLine("Czas trwania obliczeń sekwencyjnych: " + (stop - start).ToString() + " ms");

            //obliczenia równoległe
            start = System.Environment.TickCount;
            for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; powtórzenia++)
            {
                //for (int i = 0; i < rozmiar; ++i) wyniki[i] = obliczenia(tablica[i]);
                Parallel.For(0, rozmiar, (int i) => { wyniki[i] = obliczenia(tablica[i]); });
            }
            stop = System.Environment.TickCount;
            Console.WriteLine("Czas trwania obliczeń sekwencyjnych: " + (stop - start).ToString() + " ms");
        }

        static void MainSynchronicznie(string[] args)
        {
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek akcji - " + argument.ToString());
                    Thread.Sleep(5000); //5s
                    Console.WriteLine("Koniec akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            long wynik = akcja("synchronicznie");
            Console.WriteLine("Synchronicznie: " + wynik.ToString());
        }

        static void MainZadanie(string[] args)
        {
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek akcji - " + argument.ToString());
                    Thread.Sleep(5000); //5s
                    Console.WriteLine("Koniec akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("Akcja została uruchomiona");
            long wynik = zadanie.Result;
            Console.WriteLine("Zadanie: " + wynik.ToString());
        }

        static Task<long> ZróbCośAsync(object _argument)
        {
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek akcji - " + argument.ToString());
                    Thread.Sleep(5000); //5s
                    Console.WriteLine("Koniec akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            Task<long> zadanie = new Task<long>(akcja, _argument);
            zadanie.Start();
            return zadanie;
        }


        static void MainZadanieAsync(string[] args)
        {
            Task<long> zadanie = ZróbCośAsync("zadanie-async");
            Console.WriteLine("ZróbCośAsync zostało uruchomione");
            long wynik = zadanie.Result;
            Console.WriteLine("Wynik ZróbCośAsync: " + wynik.ToString());
        }

        static async void Main2()
        {
            Task<long> zadanie = ZróbCośAsync("await");            
            Console.WriteLine("ZróbCośAsync zostało uruchomione");
            //long wynik = zadanie.Result;
            long wynik = await zadanie;
            Console.WriteLine("Wynik ZróbCośAsync: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            Main2();
            Console.WriteLine("Naciśnij ENTER..."); Console.ReadLine();
        }
    }
}
