﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Choinka
{
    public partial class Form1 : Form
    {
        private Bitmap obraz = null;

        private bool czyPrzenoszenie = false;
        private int x0, y0;

        public Form1()
        {
            InitializeComponent();

            obraz = new Bitmap("choinka.png");
            //obraz.MakeTransparent(this.BackColor);
            this.Bounds = new Rectangle(0, 0, obraz.Width, obraz.Height);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(obraz, 0, 0);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            for (; Opacity > 0; Opacity -= 0.005) System.Threading.Thread.Sleep(1);
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)27) this.Close();
        }

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if(e.Button == MouseButtons.Left)
            {
                Cursor.Current = Cursors.Hand;
                czyPrzenoszenie = true;
                x0 = e.X;
                y0 = e.Y;
            }
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if(czyPrzenoszenie)
            {
                Left += e.X - x0;
                Top += e.Y - y0;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            if(czyPrzenoszenie)
            {
                Cursor.Current = Cursors.Default;
                czyPrzenoszenie = false;
            }
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void oAutorzeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("PSPiZK-NET");
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            this.WindowState = FormWindowState.Minimized;
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            this.WindowState = FormWindowState.Normal;
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
            int ileDniDoŚwiąt = (new DateTime(DateTime.Today.Year, 12, 24) - DateTime.Now).Days;
            notifyIcon1.BalloonTipText = "Do Świąt pozostało " + ileDniDoŚwiąt + " dni";
            notifyIcon1.ShowBalloonTip(3000);
        }


    }
}
