﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace TestyAutoSumowanie
{
    using StrażnikPartnera;

    [TestClass]
    public class TestyAutoSumowanie
    {
        [TestMethod]
        public void TestKonstruktora()
        {
            decimal limit = 1000;
            AutoSumowanie _as = new AutoSumowanie(limit);
            PrivateObject poas = new PrivateObject(_as);
            decimal as_limit = (decimal)poas.GetField("limit");
            decimal as_suma = (decimal)poas.GetField("suma");
            Assert.AreEqual(limit, as_limit);
            Assert.AreEqual(0, as_suma);
        }

        [TestMethod]
        public void TestMetodyDodaj()
        {
            decimal kwota=463;
            AutoSumowanie _as = new AutoSumowanie(1000);
            _as.Dodaj(kwota);
            Assert.AreEqual(kwota, _as.Suma);
            _as.Dodaj(kwota);
            Assert.AreEqual(2 * kwota, _as.Suma);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentOutOfRangeException))]
        public void TestMetodyDodaj2()
        {
            decimal kwota = 1100;
            AutoSumowanie _as = new AutoSumowanie(1000);
            _as.Dodaj(kwota);            
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestMetodyDodaj3()
        {
            decimal kwota = -100;
            AutoSumowanie _as = new AutoSumowanie(1000);
            _as.Dodaj(kwota);            
        }

        [TestMethod]
        public void TestWłasnościSuma()
        {
            AutoSumowanie _as = new AutoSumowanie(1000);
            PrivateObject poas = new PrivateObject(_as);

            poas.SetField("suma", 500M);

            Assert.AreEqual(500, _as.Suma);

            _as.Dodaj(200);
            Assert.AreEqual(700, _as.Suma);
        }
    }
}
