﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace StrażnikPartnera
{
    public class AutoSumowanie
    {
        private decimal limit;
        private decimal suma = 0;

        public AutoSumowanie(decimal limit)
        {
            this.limit = limit;
        }

        public void Dodaj(decimal kwota)
        {
            if (kwota < 0)
                throw new ArgumentException("Kwota nie może być ujemna");
            if (suma + kwota > limit)
                throw new ArgumentOutOfRangeException("Kwota zbyt duża");
            suma += kwota;
        }

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }
    }
}
