﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kontrolki
{
    public partial class ColorProgressBar : UserControl
    {
        public ColorProgressBar()
        {
            ColourBegin = Color.Yellow;
            ColourEnd = Color.Red;
            Value = 50;
            Minimum = 0;
            Maximum = 100;

            InitializeComponent();
        }

        public Color ColourBegin { get; set; }
        public Color ColourEnd { get; set; }

        private int minimum;
        private int maximum;
        private int value;

        public int Minimum 
        {
            get
            {
                return minimum;
            }
            set
            {
                if (minimum > Maximum) value = Maximum;
                minimum = value;
                Refresh();
            }
        }
        public int Maximum 
        {
            get
            {
                return maximum;
            }
            set
            {
                if (maximum < Minimum) value = Minimum;
                maximum = value;
                Refresh();
            }
        }
        public int Value 
        {
            get
            {
                return value;
            }
            set
            {
                if (value > Maximum) value = Maximum;
                if (value < Minimum) value = Minimum;
                this.value = value;
                Refresh();
            }
        }

        private void ColorProgressBar_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            float procent = (Value - Minimum) / (float)(Maximum - Minimum);

            for (int ix = 0; ix < Width * procent; ix++)
            {
                float x = ix / (float)Width;
                int _r = (int)((1 - x) * ColourBegin.R + x * ColourEnd.R);
                int _g = (int)((1 - x) * ColourBegin.G + x * ColourEnd.G);
                int _b = (int)((1 - x) * ColourBegin.B + x * ColourEnd.B);
                Pen p = new Pen(Color.FromArgb(_r, _g, _b));
                g.DrawLine(p, ix, 0, ix, Height - 1);
            }
        }


    }
}
